package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DeploymentCauseFluentImpl<T extends DeploymentCauseFluent<T>> extends BaseFluent<T> implements DeploymentCauseFluent<T>{

     VisitableBuilder<DeploymentCauseImageTrigger, ?> imageTrigger;     String type;     Map<String, Object> additionalProperties = new HashMap();
public DeploymentCauseFluentImpl(){
    
}
public DeploymentCauseFluentImpl( DeploymentCause instance ){
    this.withImageTrigger(instance.getImageTrigger()); this.withType(instance.getType()); 
}

    public DeploymentCauseImageTrigger getImageTrigger(){
    return this.imageTrigger!=null?this.imageTrigger.build():null;
    }
    public T withImageTrigger( DeploymentCauseImageTrigger imageTrigger){
    if (imageTrigger!=null){ this.imageTrigger= new DeploymentCauseImageTriggerBuilder(imageTrigger); _visitables.add(this.imageTrigger);} return (T) this;
    }
    public ImageTriggerNested<T> withNewImageTrigger(){
    return new ImageTriggerNestedImpl<T>();
    }
    public ImageTriggerNested<T> withNewImageTriggerLike( DeploymentCauseImageTrigger item){
    return new ImageTriggerNestedImpl<T>(item);
    }
    public ImageTriggerNested<T> editImageTrigger(){
    return withNewImageTriggerLike(getImageTrigger());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentCauseFluentImpl that = (DeploymentCauseFluentImpl) o;
if (imageTrigger != null ? !imageTrigger.equals(that.imageTrigger) :that.imageTrigger != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ImageTriggerNestedImpl<N> extends DeploymentCauseImageTriggerFluentImpl<ImageTriggerNested<N>> implements ImageTriggerNested<N>{

        private final DeploymentCauseImageTriggerBuilder builder;
    
             ImageTriggerNestedImpl ( DeploymentCauseImageTrigger item){
        this.builder = new DeploymentCauseImageTriggerBuilder(this, item);
        }
             ImageTriggerNestedImpl (){
        this.builder = new DeploymentCauseImageTriggerBuilder(this);
        }
    
            public N endImageTrigger(){
            return and();
        }
            public N and(){
            return (N) DeploymentCauseFluentImpl.this.withImageTrigger(builder.build());
        }
    
}


}
