package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface ClusterRoleFluent<T extends ClusterRoleFluent<T>> extends Fluent<T>{


    public ClusterRole.ApiVersion getApiVersion();    public T withApiVersion( ClusterRole.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToRules( PolicyRule ...items);    public T removeFromRules( PolicyRule ...items);    public List<PolicyRule> getRules();    public T withRules( List<PolicyRule> rules);    public T withRules( PolicyRule ...rules);    public RulesNested<T> addNewRule();    public RulesNested<T> addNewRuleLike( PolicyRule item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface RulesNested<N> extends Nested<N>, PolicyRuleFluent<RulesNested<N>>{
            public N and();            public N endRule();        
}


}
