package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class HorizontalPodAutoscalerBuilder extends HorizontalPodAutoscalerFluentImpl<HorizontalPodAutoscalerBuilder> implements VisitableBuilder<HorizontalPodAutoscaler,HorizontalPodAutoscalerBuilder>{

     HorizontalPodAutoscalerFluent<?> fluent;
public HorizontalPodAutoscalerBuilder(){
    this(new HorizontalPodAutoscaler());
}
public HorizontalPodAutoscalerBuilder( HorizontalPodAutoscalerFluent<?> fluent ){
    this(fluent, new HorizontalPodAutoscaler());
}
public HorizontalPodAutoscalerBuilder( HorizontalPodAutoscalerFluent<?> fluent , HorizontalPodAutoscaler instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withSpec(instance.getSpec()); fluent.withStatus(instance.getStatus()); 
}
public HorizontalPodAutoscalerBuilder( HorizontalPodAutoscaler instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSpec(instance.getSpec()); this.withStatus(instance.getStatus()); 
}

public EditableHorizontalPodAutoscaler build(){
    EditableHorizontalPodAutoscaler buildable = new EditableHorizontalPodAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
HorizontalPodAutoscalerBuilder that = (HorizontalPodAutoscalerBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
