package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class VolumeFluentImpl<T extends VolumeFluent<T>> extends BaseFluent<T> implements VolumeFluent<T>{

     VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;     VisitableBuilder<CephFSVolumeSource, ?> cephfs;     VisitableBuilder<CinderVolumeSource, ?> cinder;     VisitableBuilder<DownwardAPIVolumeSource, ?> downwardAPI;     VisitableBuilder<EmptyDirVolumeSource, ?> emptyDir;     VisitableBuilder<FCVolumeSource, ?> fc;     VisitableBuilder<FlockerVolumeSource, ?> flocker;     VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;     VisitableBuilder<GitRepoVolumeSource, ?> gitRepo;     VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;     VisitableBuilder<HostPathVolumeSource, ?> hostPath;     VisitableBuilder<ISCSIVolumeSource, ?> iscsi;     VisitableBuilder<MetadataVolumeSource, ?> metadata;     String name;     VisitableBuilder<NFSVolumeSource, ?> nfs;     VisitableBuilder<PersistentVolumeClaimVolumeSource, ?> persistentVolumeClaim;     VisitableBuilder<RBDVolumeSource, ?> rbd;     VisitableBuilder<SecretVolumeSource, ?> secret;     Map<String, Object> additionalProperties = new HashMap();
public VolumeFluentImpl(){
    
}
public VolumeFluentImpl( Volume instance ){
    this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); this.withCephfs(instance.getCephfs()); this.withCinder(instance.getCinder()); this.withDownwardAPI(instance.getDownwardAPI()); this.withEmptyDir(instance.getEmptyDir()); this.withFc(instance.getFc()); this.withFlocker(instance.getFlocker()); this.withGcePersistentDisk(instance.getGcePersistentDisk()); this.withGitRepo(instance.getGitRepo()); this.withGlusterfs(instance.getGlusterfs()); this.withHostPath(instance.getHostPath()); this.withIscsi(instance.getIscsi()); this.withMetadata(instance.getMetadata()); this.withName(instance.getName()); this.withNfs(instance.getNfs()); this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); this.withRbd(instance.getRbd()); this.withSecret(instance.getSecret()); 
}

    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore(){
    return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
    }
    public T withAwsElasticBlockStore( AWSElasticBlockStoreVolumeSource awsElasticBlockStore){
    if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.add(this.awsElasticBlockStore);} return (T) this;
    }
    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore(){
    return new AwsElasticBlockStoreNestedImpl<T>();
    }
    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike( AWSElasticBlockStoreVolumeSource item){
    return new AwsElasticBlockStoreNestedImpl<T>(item);
    }
    public AwsElasticBlockStoreNested<T> editAwsElasticBlockStore(){
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
    }
    public T withNewAwsElasticBlockStore( String fsType,  Integer partition,  Boolean readOnly,  String volumeID){
    return withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }
    public CephFSVolumeSource getCephfs(){
    return this.cephfs!=null?this.cephfs.build():null;
    }
    public T withCephfs( CephFSVolumeSource cephfs){
    if (cephfs!=null){ this.cephfs= new CephFSVolumeSourceBuilder(cephfs); _visitables.add(this.cephfs);} return (T) this;
    }
    public CephfsNested<T> withNewCephfs(){
    return new CephfsNestedImpl<T>();
    }
    public CephfsNested<T> withNewCephfsLike( CephFSVolumeSource item){
    return new CephfsNestedImpl<T>(item);
    }
    public CephfsNested<T> editCephfs(){
    return withNewCephfsLike(getCephfs());
    }
    public CinderVolumeSource getCinder(){
    return this.cinder!=null?this.cinder.build():null;
    }
    public T withCinder( CinderVolumeSource cinder){
    if (cinder!=null){ this.cinder= new CinderVolumeSourceBuilder(cinder); _visitables.add(this.cinder);} return (T) this;
    }
    public CinderNested<T> withNewCinder(){
    return new CinderNestedImpl<T>();
    }
    public CinderNested<T> withNewCinderLike( CinderVolumeSource item){
    return new CinderNestedImpl<T>(item);
    }
    public CinderNested<T> editCinder(){
    return withNewCinderLike(getCinder());
    }
    public T withNewCinder( String fsType,  Boolean readOnly,  String volumeID){
    return withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }
    public DownwardAPIVolumeSource getDownwardAPI(){
    return this.downwardAPI!=null?this.downwardAPI.build():null;
    }
    public T withDownwardAPI( DownwardAPIVolumeSource downwardAPI){
    if (downwardAPI!=null){ this.downwardAPI= new DownwardAPIVolumeSourceBuilder(downwardAPI); _visitables.add(this.downwardAPI);} return (T) this;
    }
    public DownwardAPINested<T> withNewDownwardAPI(){
    return new DownwardAPINestedImpl<T>();
    }
    public DownwardAPINested<T> withNewDownwardAPILike( DownwardAPIVolumeSource item){
    return new DownwardAPINestedImpl<T>(item);
    }
    public DownwardAPINested<T> editDownwardAPI(){
    return withNewDownwardAPILike(getDownwardAPI());
    }
    public EmptyDirVolumeSource getEmptyDir(){
    return this.emptyDir!=null?this.emptyDir.build():null;
    }
    public T withEmptyDir( EmptyDirVolumeSource emptyDir){
    if (emptyDir!=null){ this.emptyDir= new EmptyDirVolumeSourceBuilder(emptyDir); _visitables.add(this.emptyDir);} return (T) this;
    }
    public EmptyDirNested<T> withNewEmptyDir(){
    return new EmptyDirNestedImpl<T>();
    }
    public EmptyDirNested<T> withNewEmptyDirLike( EmptyDirVolumeSource item){
    return new EmptyDirNestedImpl<T>(item);
    }
    public EmptyDirNested<T> editEmptyDir(){
    return withNewEmptyDirLike(getEmptyDir());
    }
    public T withNewEmptyDir( String medium){
    return withEmptyDir(new EmptyDirVolumeSource(medium));
    }
    public FCVolumeSource getFc(){
    return this.fc!=null?this.fc.build():null;
    }
    public T withFc( FCVolumeSource fc){
    if (fc!=null){ this.fc= new FCVolumeSourceBuilder(fc); _visitables.add(this.fc);} return (T) this;
    }
    public FcNested<T> withNewFc(){
    return new FcNestedImpl<T>();
    }
    public FcNested<T> withNewFcLike( FCVolumeSource item){
    return new FcNestedImpl<T>(item);
    }
    public FcNested<T> editFc(){
    return withNewFcLike(getFc());
    }
    public FlockerVolumeSource getFlocker(){
    return this.flocker!=null?this.flocker.build():null;
    }
    public T withFlocker( FlockerVolumeSource flocker){
    if (flocker!=null){ this.flocker= new FlockerVolumeSourceBuilder(flocker); _visitables.add(this.flocker);} return (T) this;
    }
    public FlockerNested<T> withNewFlocker(){
    return new FlockerNestedImpl<T>();
    }
    public FlockerNested<T> withNewFlockerLike( FlockerVolumeSource item){
    return new FlockerNestedImpl<T>(item);
    }
    public FlockerNested<T> editFlocker(){
    return withNewFlockerLike(getFlocker());
    }
    public T withNewFlocker( String datasetName){
    return withFlocker(new FlockerVolumeSource(datasetName));
    }
    public GCEPersistentDiskVolumeSource getGcePersistentDisk(){
    return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
    }
    public T withGcePersistentDisk( GCEPersistentDiskVolumeSource gcePersistentDisk){
    if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.add(this.gcePersistentDisk);} return (T) this;
    }
    public GcePersistentDiskNested<T> withNewGcePersistentDisk(){
    return new GcePersistentDiskNestedImpl<T>();
    }
    public GcePersistentDiskNested<T> withNewGcePersistentDiskLike( GCEPersistentDiskVolumeSource item){
    return new GcePersistentDiskNestedImpl<T>(item);
    }
    public GcePersistentDiskNested<T> editGcePersistentDisk(){
    return withNewGcePersistentDiskLike(getGcePersistentDisk());
    }
    public T withNewGcePersistentDisk( String fsType,  Integer partition,  String pdName,  Boolean readOnly){
    return withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }
    public GitRepoVolumeSource getGitRepo(){
    return this.gitRepo!=null?this.gitRepo.build():null;
    }
    public T withGitRepo( GitRepoVolumeSource gitRepo){
    if (gitRepo!=null){ this.gitRepo= new GitRepoVolumeSourceBuilder(gitRepo); _visitables.add(this.gitRepo);} return (T) this;
    }
    public GitRepoNested<T> withNewGitRepo(){
    return new GitRepoNestedImpl<T>();
    }
    public GitRepoNested<T> withNewGitRepoLike( GitRepoVolumeSource item){
    return new GitRepoNestedImpl<T>(item);
    }
    public GitRepoNested<T> editGitRepo(){
    return withNewGitRepoLike(getGitRepo());
    }
    public T withNewGitRepo( String repository,  String revision){
    return withGitRepo(new GitRepoVolumeSource(repository, revision));
    }
    public GlusterfsVolumeSource getGlusterfs(){
    return this.glusterfs!=null?this.glusterfs.build():null;
    }
    public T withGlusterfs( GlusterfsVolumeSource glusterfs){
    if (glusterfs!=null){ this.glusterfs= new GlusterfsVolumeSourceBuilder(glusterfs); _visitables.add(this.glusterfs);} return (T) this;
    }
    public GlusterfsNested<T> withNewGlusterfs(){
    return new GlusterfsNestedImpl<T>();
    }
    public GlusterfsNested<T> withNewGlusterfsLike( GlusterfsVolumeSource item){
    return new GlusterfsNestedImpl<T>(item);
    }
    public GlusterfsNested<T> editGlusterfs(){
    return withNewGlusterfsLike(getGlusterfs());
    }
    public T withNewGlusterfs( String endpoints,  String path,  Boolean readOnly){
    return withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }
    public HostPathVolumeSource getHostPath(){
    return this.hostPath!=null?this.hostPath.build():null;
    }
    public T withHostPath( HostPathVolumeSource hostPath){
    if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.add(this.hostPath);} return (T) this;
    }
    public HostPathNested<T> withNewHostPath(){
    return new HostPathNestedImpl<T>();
    }
    public HostPathNested<T> withNewHostPathLike( HostPathVolumeSource item){
    return new HostPathNestedImpl<T>(item);
    }
    public HostPathNested<T> editHostPath(){
    return withNewHostPathLike(getHostPath());
    }
    public T withNewHostPath( String path){
    return withHostPath(new HostPathVolumeSource(path));
    }
    public ISCSIVolumeSource getIscsi(){
    return this.iscsi!=null?this.iscsi.build():null;
    }
    public T withIscsi( ISCSIVolumeSource iscsi){
    if (iscsi!=null){ this.iscsi= new ISCSIVolumeSourceBuilder(iscsi); _visitables.add(this.iscsi);} return (T) this;
    }
    public IscsiNested<T> withNewIscsi(){
    return new IscsiNestedImpl<T>();
    }
    public IscsiNested<T> withNewIscsiLike( ISCSIVolumeSource item){
    return new IscsiNestedImpl<T>(item);
    }
    public IscsiNested<T> editIscsi(){
    return withNewIscsiLike(getIscsi());
    }
    public T withNewIscsi( String fsType,  String iqn,  Integer lun,  Boolean readOnly,  String targetPortal){
    return withIscsi(new ISCSIVolumeSource(fsType, iqn, lun, readOnly, targetPortal));
    }
    public MetadataVolumeSource getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( MetadataVolumeSource metadata){
    if (metadata!=null){ this.metadata= new MetadataVolumeSourceBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( MetadataVolumeSource item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public NFSVolumeSource getNfs(){
    return this.nfs!=null?this.nfs.build():null;
    }
    public T withNfs( NFSVolumeSource nfs){
    if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.add(this.nfs);} return (T) this;
    }
    public NfsNested<T> withNewNfs(){
    return new NfsNestedImpl<T>();
    }
    public NfsNested<T> withNewNfsLike( NFSVolumeSource item){
    return new NfsNestedImpl<T>(item);
    }
    public NfsNested<T> editNfs(){
    return withNewNfsLike(getNfs());
    }
    public T withNewNfs( String path,  Boolean readOnly,  String server){
    return withNfs(new NFSVolumeSource(path, readOnly, server));
    }
    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim(){
    return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }
    public T withPersistentVolumeClaim( PersistentVolumeClaimVolumeSource persistentVolumeClaim){
    if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new PersistentVolumeClaimVolumeSourceBuilder(persistentVolumeClaim); _visitables.add(this.persistentVolumeClaim);} return (T) this;
    }
    public PersistentVolumeClaimNested<T> withNewPersistentVolumeClaim(){
    return new PersistentVolumeClaimNestedImpl<T>();
    }
    public PersistentVolumeClaimNested<T> withNewPersistentVolumeClaimLike( PersistentVolumeClaimVolumeSource item){
    return new PersistentVolumeClaimNestedImpl<T>(item);
    }
    public PersistentVolumeClaimNested<T> editPersistentVolumeClaim(){
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
    }
    public T withNewPersistentVolumeClaim( String claimName,  Boolean readOnly){
    return withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
    }
    public RBDVolumeSource getRbd(){
    return this.rbd!=null?this.rbd.build():null;
    }
    public T withRbd( RBDVolumeSource rbd){
    if (rbd!=null){ this.rbd= new RBDVolumeSourceBuilder(rbd); _visitables.add(this.rbd);} return (T) this;
    }
    public RbdNested<T> withNewRbd(){
    return new RbdNestedImpl<T>();
    }
    public RbdNested<T> withNewRbdLike( RBDVolumeSource item){
    return new RbdNestedImpl<T>(item);
    }
    public RbdNested<T> editRbd(){
    return withNewRbdLike(getRbd());
    }
    public SecretVolumeSource getSecret(){
    return this.secret!=null?this.secret.build():null;
    }
    public T withSecret( SecretVolumeSource secret){
    if (secret!=null){ this.secret= new SecretVolumeSourceBuilder(secret); _visitables.add(this.secret);} return (T) this;
    }
    public SecretNested<T> withNewSecret(){
    return new SecretNestedImpl<T>();
    }
    public SecretNested<T> withNewSecretLike( SecretVolumeSource item){
    return new SecretNestedImpl<T>(item);
    }
    public SecretNested<T> editSecret(){
    return withNewSecretLike(getSecret());
    }
    public T withNewSecret( String secretName){
    return withSecret(new SecretVolumeSource(secretName));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
VolumeFluentImpl that = (VolumeFluentImpl) o;
if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
if (cinder != null ? !cinder.equals(that.cinder) :that.cinder != null) return false;
if (downwardAPI != null ? !downwardAPI.equals(that.downwardAPI) :that.downwardAPI != null) return false;
if (emptyDir != null ? !emptyDir.equals(that.emptyDir) :that.emptyDir != null) return false;
if (fc != null ? !fc.equals(that.fc) :that.fc != null) return false;
if (flocker != null ? !flocker.equals(that.flocker) :that.flocker != null) return false;
if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
if (gitRepo != null ? !gitRepo.equals(that.gitRepo) :that.gitRepo != null) return false;
if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class AwsElasticBlockStoreNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<AwsElasticBlockStoreNested<N>> implements AwsElasticBlockStoreNested<N>{

        private final AWSElasticBlockStoreVolumeSourceBuilder builder;
    
             AwsElasticBlockStoreNestedImpl (){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }
             AwsElasticBlockStoreNestedImpl ( AWSElasticBlockStoreVolumeSource item){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }
    
            public N endAwsElasticBlockStore(){
            return and();
        }
            public N and(){
            return (N) VolumeFluentImpl.this.withAwsElasticBlockStore(builder.build());
        }
    
}
    public class CephfsNestedImpl<N> extends CephFSVolumeSourceFluentImpl<CephfsNested<N>> implements CephfsNested<N>{

        private final CephFSVolumeSourceBuilder builder;
    
             CephfsNestedImpl (){
        this.builder = new CephFSVolumeSourceBuilder(this);
        }
             CephfsNestedImpl ( CephFSVolumeSource item){
        this.builder = new CephFSVolumeSourceBuilder(this, item);
        }
    
            public N endCephfs(){
            return and();
        }
            public N and(){
            return (N) VolumeFluentImpl.this.withCephfs(builder.build());
        }
    
}
    public class CinderNestedImpl<N> extends CinderVolumeSourceFluentImpl<CinderNested<N>> implements CinderNested<N>{

        private final CinderVolumeSourceBuilder builder;
    
             CinderNestedImpl (){
        this.builder = new CinderVolumeSourceBuilder(this);
        }
             CinderNestedImpl ( CinderVolumeSource item){
        this.builder = new CinderVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluentImpl.this.withCinder(builder.build());
        }
            public N endCinder(){
            return and();
        }
    
}
    public class DownwardAPINestedImpl<N> extends DownwardAPIVolumeSourceFluentImpl<DownwardAPINested<N>> implements DownwardAPINested<N>{

        private final DownwardAPIVolumeSourceBuilder builder;
    
             DownwardAPINestedImpl (){
        this.builder = new DownwardAPIVolumeSourceBuilder(this);
        }
             DownwardAPINestedImpl ( DownwardAPIVolumeSource item){
        this.builder = new DownwardAPIVolumeSourceBuilder(this, item);
        }
    
            public N endDownwardAPI(){
            return and();
        }
            public N and(){
            return (N) VolumeFluentImpl.this.withDownwardAPI(builder.build());
        }
    
}
    public class EmptyDirNestedImpl<N> extends EmptyDirVolumeSourceFluentImpl<EmptyDirNested<N>> implements EmptyDirNested<N>{

        private final EmptyDirVolumeSourceBuilder builder;
    
             EmptyDirNestedImpl ( EmptyDirVolumeSource item){
        this.builder = new EmptyDirVolumeSourceBuilder(this, item);
        }
             EmptyDirNestedImpl (){
        this.builder = new EmptyDirVolumeSourceBuilder(this);
        }
    
            public N endEmptyDir(){
            return and();
        }
            public N and(){
            return (N) VolumeFluentImpl.this.withEmptyDir(builder.build());
        }
    
}
    public class FcNestedImpl<N> extends FCVolumeSourceFluentImpl<FcNested<N>> implements FcNested<N>{

        private final FCVolumeSourceBuilder builder;
    
             FcNestedImpl (){
        this.builder = new FCVolumeSourceBuilder(this);
        }
             FcNestedImpl ( FCVolumeSource item){
        this.builder = new FCVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluentImpl.this.withFc(builder.build());
        }
            public N endFc(){
            return and();
        }
    
}
    public class FlockerNestedImpl<N> extends FlockerVolumeSourceFluentImpl<FlockerNested<N>> implements FlockerNested<N>{

        private final FlockerVolumeSourceBuilder builder;
    
             FlockerNestedImpl (){
        this.builder = new FlockerVolumeSourceBuilder(this);
        }
             FlockerNestedImpl ( FlockerVolumeSource item){
        this.builder = new FlockerVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluentImpl.this.withFlocker(builder.build());
        }
            public N endFlocker(){
            return and();
        }
    
}
    public class GcePersistentDiskNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<GcePersistentDiskNested<N>> implements GcePersistentDiskNested<N>{

        private final GCEPersistentDiskVolumeSourceBuilder builder;
    
             GcePersistentDiskNestedImpl (){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }
             GcePersistentDiskNestedImpl ( GCEPersistentDiskVolumeSource item){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }
    
            public N endGcePersistentDisk(){
            return and();
        }
            public N and(){
            return (N) VolumeFluentImpl.this.withGcePersistentDisk(builder.build());
        }
    
}
    public class GitRepoNestedImpl<N> extends GitRepoVolumeSourceFluentImpl<GitRepoNested<N>> implements GitRepoNested<N>{

        private final GitRepoVolumeSourceBuilder builder;
    
             GitRepoNestedImpl (){
        this.builder = new GitRepoVolumeSourceBuilder(this);
        }
             GitRepoNestedImpl ( GitRepoVolumeSource item){
        this.builder = new GitRepoVolumeSourceBuilder(this, item);
        }
    
            public N endGitRepo(){
            return and();
        }
            public N and(){
            return (N) VolumeFluentImpl.this.withGitRepo(builder.build());
        }
    
}
    public class GlusterfsNestedImpl<N> extends GlusterfsVolumeSourceFluentImpl<GlusterfsNested<N>> implements GlusterfsNested<N>{

        private final GlusterfsVolumeSourceBuilder builder;
    
             GlusterfsNestedImpl (){
        this.builder = new GlusterfsVolumeSourceBuilder(this);
        }
             GlusterfsNestedImpl ( GlusterfsVolumeSource item){
        this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluentImpl.this.withGlusterfs(builder.build());
        }
            public N endGlusterfs(){
            return and();
        }
    
}
    public class HostPathNestedImpl<N> extends HostPathVolumeSourceFluentImpl<HostPathNested<N>> implements HostPathNested<N>{

        private final HostPathVolumeSourceBuilder builder;
    
             HostPathNestedImpl (){
        this.builder = new HostPathVolumeSourceBuilder(this);
        }
             HostPathNestedImpl ( HostPathVolumeSource item){
        this.builder = new HostPathVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluentImpl.this.withHostPath(builder.build());
        }
            public N endHostPath(){
            return and();
        }
    
}
    public class IscsiNestedImpl<N> extends ISCSIVolumeSourceFluentImpl<IscsiNested<N>> implements IscsiNested<N>{

        private final ISCSIVolumeSourceBuilder builder;
    
             IscsiNestedImpl ( ISCSIVolumeSource item){
        this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }
             IscsiNestedImpl (){
        this.builder = new ISCSIVolumeSourceBuilder(this);
        }
    
            public N and(){
            return (N) VolumeFluentImpl.this.withIscsi(builder.build());
        }
            public N endIscsi(){
            return and();
        }
    
}
    public class MetadataNestedImpl<N> extends MetadataVolumeSourceFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final MetadataVolumeSourceBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new MetadataVolumeSourceBuilder(this);
        }
             MetadataNestedImpl ( MetadataVolumeSource item){
        this.builder = new MetadataVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class NfsNestedImpl<N> extends NFSVolumeSourceFluentImpl<NfsNested<N>> implements NfsNested<N>{

        private final NFSVolumeSourceBuilder builder;
    
             NfsNestedImpl (){
        this.builder = new NFSVolumeSourceBuilder(this);
        }
             NfsNestedImpl ( NFSVolumeSource item){
        this.builder = new NFSVolumeSourceBuilder(this, item);
        }
    
            public N endNfs(){
            return and();
        }
            public N and(){
            return (N) VolumeFluentImpl.this.withNfs(builder.build());
        }
    
}
    public class PersistentVolumeClaimNestedImpl<N> extends PersistentVolumeClaimVolumeSourceFluentImpl<PersistentVolumeClaimNested<N>> implements PersistentVolumeClaimNested<N>{

        private final PersistentVolumeClaimVolumeSourceBuilder builder;
    
             PersistentVolumeClaimNestedImpl (){
        this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this);
        }
             PersistentVolumeClaimNestedImpl ( PersistentVolumeClaimVolumeSource item){
        this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
        }
    
            public N endPersistentVolumeClaim(){
            return and();
        }
            public N and(){
            return (N) VolumeFluentImpl.this.withPersistentVolumeClaim(builder.build());
        }
    
}
    public class RbdNestedImpl<N> extends RBDVolumeSourceFluentImpl<RbdNested<N>> implements RbdNested<N>{

        private final RBDVolumeSourceBuilder builder;
    
             RbdNestedImpl (){
        this.builder = new RBDVolumeSourceBuilder(this);
        }
             RbdNestedImpl ( RBDVolumeSource item){
        this.builder = new RBDVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluentImpl.this.withRbd(builder.build());
        }
            public N endRbd(){
            return and();
        }
    
}
    public class SecretNestedImpl<N> extends SecretVolumeSourceFluentImpl<SecretNested<N>> implements SecretNested<N>{

        private final SecretVolumeSourceBuilder builder;
    
             SecretNestedImpl (){
        this.builder = new SecretVolumeSourceBuilder(this);
        }
             SecretNestedImpl ( SecretVolumeSource item){
        this.builder = new SecretVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumeFluentImpl.this.withSecret(builder.build());
        }
            public N endSecret(){
            return and();
        }
    
}


}
