package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class StatusBuilder extends StatusFluentImpl<StatusBuilder> implements VisitableBuilder<Status,StatusBuilder>{

     StatusFluent<?> fluent;
public StatusBuilder(){
    this(new Status());
}
public StatusBuilder( StatusFluent<?> fluent ){
    this(fluent, new Status());
}
public StatusBuilder( StatusFluent<?> fluent , Status instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withCode(instance.getCode()); fluent.withDetails(instance.getDetails()); fluent.withKind(instance.getKind()); fluent.withMessage(instance.getMessage()); fluent.withMetadata(instance.getMetadata()); fluent.withReason(instance.getReason()); fluent.withStatus(instance.getStatus()); 
}
public StatusBuilder( Status instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withCode(instance.getCode()); this.withDetails(instance.getDetails()); this.withKind(instance.getKind()); this.withMessage(instance.getMessage()); this.withMetadata(instance.getMetadata()); this.withReason(instance.getReason()); this.withStatus(instance.getStatus()); 
}

public EditableStatus build(){
    EditableStatus buildable = new EditableStatus(fluent.getApiVersion(),fluent.getCode(),fluent.getDetails(),fluent.getKind(),fluent.getMessage(),fluent.getMetadata(),fluent.getReason(),fluent.getStatus());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
StatusBuilder that = (StatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
