package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ServiceAccountFluentImpl<T extends ServiceAccountFluent<T>> extends BaseFluent<T> implements ServiceAccountFluent<T>{

     ServiceAccount.ApiVersion apiVersion;     List<VisitableBuilder<LocalObjectReference, ?>> imagePullSecrets = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<ObjectReference, ?>> secrets = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public ServiceAccountFluentImpl(){
    
}
public ServiceAccountFluentImpl( ServiceAccount instance ){
    this.withApiVersion(instance.getApiVersion()); this.withImagePullSecrets(instance.getImagePullSecrets()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSecrets(instance.getSecrets()); 
}

    public ServiceAccount.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ServiceAccount.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToImagePullSecrets( LocalObjectReference ...items){
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.add(builder);this.imagePullSecrets.add(builder);} return (T)this;
    }
    public T removeFromImagePullSecrets( LocalObjectReference ...items){
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.remove(builder);this.imagePullSecrets.remove(builder);} return (T)this;
    }
    public List<LocalObjectReference> getImagePullSecrets(){
    return build(imagePullSecrets);
    }
    public T withImagePullSecrets( List<LocalObjectReference> imagePullSecrets){
    this.imagePullSecrets.clear();if (imagePullSecrets != null) {for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} return (T) this;
    }
    public T withImagePullSecrets( LocalObjectReference ...imagePullSecrets){
    this.imagePullSecrets.clear(); if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (T) this;
    }
    public ImagePullSecretsNested<T> addNewImagePullSecret(){
    return new ImagePullSecretsNestedImpl<T>();
    }
    public ImagePullSecretsNested<T> addNewImagePullSecretLike( LocalObjectReference item){
    return new ImagePullSecretsNestedImpl<T>(item);
    }
    public T addNewImagePullSecret( String name){
    return addToImagePullSecrets(new LocalObjectReference(name));
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToSecrets( ObjectReference ...items){
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.add(builder);this.secrets.add(builder);} return (T)this;
    }
    public T removeFromSecrets( ObjectReference ...items){
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.remove(builder);this.secrets.remove(builder);} return (T)this;
    }
    public List<ObjectReference> getSecrets(){
    return build(secrets);
    }
    public T withSecrets( List<ObjectReference> secrets){
    this.secrets.clear();if (secrets != null) {for (ObjectReference item : secrets){this.addToSecrets(item);}} return (T) this;
    }
    public T withSecrets( ObjectReference ...secrets){
    this.secrets.clear(); if (secrets != null) {for (ObjectReference item :secrets){ this.addToSecrets(item);}} return (T) this;
    }
    public SecretsNested<T> addNewSecret(){
    return new SecretsNestedImpl<T>();
    }
    public SecretsNested<T> addNewSecretLike( ObjectReference item){
    return new SecretsNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ServiceAccountFluentImpl that = (ServiceAccountFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<ImagePullSecretsNested<N>> implements ImagePullSecretsNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             ImagePullSecretsNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
             ImagePullSecretsNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
    
            public N and(){
            return (N) ServiceAccountFluentImpl.this.addToImagePullSecrets(builder.build());
        }
            public N endImagePullSecret(){
            return and();
        }
    
}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) ServiceAccountFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SecretsNestedImpl<N> extends ObjectReferenceFluentImpl<SecretsNested<N>> implements SecretsNested<N>{

        private final ObjectReferenceBuilder builder;
    
             SecretsNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             SecretsNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) ServiceAccountFluentImpl.this.addToSecrets(builder.build());
        }
            public N endSecret(){
            return and();
        }
    
}


}
