package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class ContainerStatusBuilder extends ContainerStatusFluentImpl<ContainerStatusBuilder> implements VisitableBuilder<ContainerStatus,ContainerStatusBuilder>{

     ContainerStatusFluent<?> fluent;
public ContainerStatusBuilder(){
    this(new ContainerStatus());
}
public ContainerStatusBuilder( ContainerStatusFluent<?> fluent ){
    this(fluent, new ContainerStatus());
}
public ContainerStatusBuilder( ContainerStatusFluent<?> fluent , ContainerStatus instance ){
    this.fluent = fluent; fluent.withContainerID(instance.getContainerID()); fluent.withImage(instance.getImage()); fluent.withImageID(instance.getImageID()); fluent.withLastState(instance.getLastState()); fluent.withName(instance.getName()); fluent.withReady(instance.getReady()); fluent.withRestartCount(instance.getRestartCount()); fluent.withState(instance.getState()); 
}
public ContainerStatusBuilder( ContainerStatus instance ){
    this.fluent = this; this.withContainerID(instance.getContainerID()); this.withImage(instance.getImage()); this.withImageID(instance.getImageID()); this.withLastState(instance.getLastState()); this.withName(instance.getName()); this.withReady(instance.getReady()); this.withRestartCount(instance.getRestartCount()); this.withState(instance.getState()); 
}

public EditableContainerStatus build(){
    EditableContainerStatus buildable = new EditableContainerStatus(fluent.getContainerID(),fluent.getImage(),fluent.getImageID(),fluent.getLastState(),fluent.getName(),fluent.isReady(),fluent.getRestartCount(),fluent.getState());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerStatusBuilder that = (ContainerStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
