package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public class RouteSpecFluentImpl<T extends RouteSpecFluent<T>> extends BaseFluent<T> implements RouteSpecFluent<T>{

     String host;     String path;     VisitableBuilder<RoutePort, ?> port;     VisitableBuilder<TLSConfig, ?> tls;     VisitableBuilder<ObjectReference, ?> to;     Map<String, Object> additionalProperties = new HashMap();
public RouteSpecFluentImpl(){
    
}
public RouteSpecFluentImpl( RouteSpec instance ){
    this.withHost(instance.getHost()); this.withPath(instance.getPath()); this.withPort(instance.getPort()); this.withTls(instance.getTls()); this.withTo(instance.getTo()); 
}

    public String getHost(){
    return this.host;
    }
    public T withHost( String host){
    this.host=host; return (T) this;
    }
    public String getPath(){
    return this.path;
    }
    public T withPath( String path){
    this.path=path; return (T) this;
    }
    public RoutePort getPort(){
    return this.port!=null?this.port.build():null;
    }
    public T withPort( RoutePort port){
    if (port!=null){ this.port= new RoutePortBuilder(port); _visitables.add(this.port);} return (T) this;
    }
    public PortNested<T> withNewPort(){
    return new PortNestedImpl<T>();
    }
    public PortNested<T> withNewPortLike( RoutePort item){
    return new PortNestedImpl<T>(item);
    }
    public PortNested<T> editPort(){
    return withNewPortLike(getPort());
    }
    public TLSConfig getTls(){
    return this.tls!=null?this.tls.build():null;
    }
    public T withTls( TLSConfig tls){
    if (tls!=null){ this.tls= new TLSConfigBuilder(tls); _visitables.add(this.tls);} return (T) this;
    }
    public TlsNested<T> withNewTls(){
    return new TlsNestedImpl<T>();
    }
    public TlsNested<T> withNewTlsLike( TLSConfig item){
    return new TlsNestedImpl<T>(item);
    }
    public TlsNested<T> editTls(){
    return withNewTlsLike(getTls());
    }
    public ObjectReference getTo(){
    return this.to!=null?this.to.build():null;
    }
    public T withTo( ObjectReference to){
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.add(this.to);} return (T) this;
    }
    public ToNested<T> withNewTo(){
    return new ToNestedImpl<T>();
    }
    public ToNested<T> withNewToLike( ObjectReference item){
    return new ToNestedImpl<T>(item);
    }
    public ToNested<T> editTo(){
    return withNewToLike(getTo());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RouteSpecFluentImpl that = (RouteSpecFluentImpl) o;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (path != null ? !path.equals(that.path) :that.path != null) return false;
if (port != null ? !port.equals(that.port) :that.port != null) return false;
if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
if (to != null ? !to.equals(that.to) :that.to != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class PortNestedImpl<N> extends RoutePortFluentImpl<PortNested<N>> implements PortNested<N>{

        private final RoutePortBuilder builder;
    
             PortNestedImpl (){
        this.builder = new RoutePortBuilder(this);
        }
             PortNestedImpl ( RoutePort item){
        this.builder = new RoutePortBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) RouteSpecFluentImpl.this.withPort(builder.build());
        }
    
}
    public class TlsNestedImpl<N> extends TLSConfigFluentImpl<TlsNested<N>> implements TlsNested<N>{

        private final TLSConfigBuilder builder;
    
             TlsNestedImpl (){
        this.builder = new TLSConfigBuilder(this);
        }
             TlsNestedImpl ( TLSConfig item){
        this.builder = new TLSConfigBuilder(this, item);
        }
    
            public N endTls(){
            return and();
        }
            public N and(){
            return (N) RouteSpecFluentImpl.this.withTls(builder.build());
        }
    
}
    public class ToNestedImpl<N> extends ObjectReferenceFluentImpl<ToNested<N>> implements ToNested<N>{

        private final ObjectReferenceBuilder builder;
    
             ToNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
             ToNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
    
            public N and(){
            return (N) RouteSpecFluentImpl.this.withTo(builder.build());
        }
            public N endTo(){
            return and();
        }
    
}


}
