package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public class BuildStatusFluentImpl<T extends BuildStatusFluent<T>> extends BaseFluent<T> implements BuildStatusFluent<T>{

     Boolean cancelled;     String completionTimestamp;     VisitableBuilder<ObjectReference, ?> config;     Long duration;     String message;     String outputDockerImageReference;     String phase;     String reason;     String startTimestamp;     Map<String, Object> additionalProperties = new HashMap();
public BuildStatusFluentImpl(){
    
}
public BuildStatusFluentImpl( BuildStatus instance ){
    this.withCancelled(instance.getCancelled()); this.withCompletionTimestamp(instance.getCompletionTimestamp()); this.withConfig(instance.getConfig()); this.withDuration(instance.getDuration()); this.withMessage(instance.getMessage()); this.withOutputDockerImageReference(instance.getOutputDockerImageReference()); this.withPhase(instance.getPhase()); this.withReason(instance.getReason()); this.withStartTimestamp(instance.getStartTimestamp()); 
}

    public Boolean isCancelled(){
    return this.cancelled;
    }
    public T withCancelled( Boolean cancelled){
    this.cancelled=cancelled; return (T) this;
    }
    public String getCompletionTimestamp(){
    return this.completionTimestamp;
    }
    public T withCompletionTimestamp( String completionTimestamp){
    this.completionTimestamp=completionTimestamp; return (T) this;
    }
    public ObjectReference getConfig(){
    return this.config!=null?this.config.build():null;
    }
    public T withConfig( ObjectReference config){
    if (config!=null){ this.config= new ObjectReferenceBuilder(config); _visitables.add(this.config);} return (T) this;
    }
    public ConfigNested<T> withNewConfig(){
    return new ConfigNestedImpl<T>();
    }
    public ConfigNested<T> withNewConfigLike( ObjectReference item){
    return new ConfigNestedImpl<T>(item);
    }
    public ConfigNested<T> editConfig(){
    return withNewConfigLike(getConfig());
    }
    public Long getDuration(){
    return this.duration;
    }
    public T withDuration( Long duration){
    this.duration=duration; return (T) this;
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public String getOutputDockerImageReference(){
    return this.outputDockerImageReference;
    }
    public T withOutputDockerImageReference( String outputDockerImageReference){
    this.outputDockerImageReference=outputDockerImageReference; return (T) this;
    }
    public String getPhase(){
    return this.phase;
    }
    public T withPhase( String phase){
    this.phase=phase; return (T) this;
    }
    public String getReason(){
    return this.reason;
    }
    public T withReason( String reason){
    this.reason=reason; return (T) this;
    }
    public String getStartTimestamp(){
    return this.startTimestamp;
    }
    public T withStartTimestamp( String startTimestamp){
    this.startTimestamp=startTimestamp; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildStatusFluentImpl that = (BuildStatusFluentImpl) o;
if (cancelled != null ? !cancelled.equals(that.cancelled) :that.cancelled != null) return false;
if (completionTimestamp != null ? !completionTimestamp.equals(that.completionTimestamp) :that.completionTimestamp != null) return false;
if (config != null ? !config.equals(that.config) :that.config != null) return false;
if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (outputDockerImageReference != null ? !outputDockerImageReference.equals(that.outputDockerImageReference) :that.outputDockerImageReference != null) return false;
if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
if (startTimestamp != null ? !startTimestamp.equals(that.startTimestamp) :that.startTimestamp != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConfigNestedImpl<N> extends ObjectReferenceFluentImpl<ConfigNested<N>> implements ConfigNested<N>{

        private final ObjectReferenceBuilder builder;
    
             ConfigNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ConfigNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endConfig(){
            return and();
        }
            public N and(){
            return (N) BuildStatusFluentImpl.this.withConfig(builder.build());
        }
    
}


}
