package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface BuildStatusFluent<T extends BuildStatusFluent<T>> extends Fluent<T>{


    public Boolean isCancelled();    public T withCancelled( Boolean cancelled);    public String getCompletionTimestamp();    public T withCompletionTimestamp( String completionTimestamp);    public ObjectReference getConfig();    public T withConfig( ObjectReference config);    public ConfigNested<T> withNewConfig();    public ConfigNested<T> withNewConfigLike( ObjectReference item);    public ConfigNested<T> editConfig();    public Long getDuration();    public T withDuration( Long duration);    public String getMessage();    public T withMessage( String message);    public String getOutputDockerImageReference();    public T withOutputDockerImageReference( String outputDockerImageReference);    public String getPhase();    public T withPhase( String phase);    public String getReason();    public T withReason( String reason);    public String getStartTimestamp();    public T withStartTimestamp( String startTimestamp);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ConfigNested<N> extends Nested<N>, ObjectReferenceFluent<ConfigNested<N>>{
            public N endConfig();            public N and();        
}


}
