package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class JobStatusFluentImpl<T extends JobStatusFluent<T>> extends BaseFluent<T> implements JobStatusFluent<T>{

     Integer active;     String completionTime;     List<VisitableBuilder<JobCondition, ?>> conditions = new ArrayList();     Integer failed;     String startTime;     Integer succeeded;     Map<String, Object> additionalProperties = new HashMap();
public JobStatusFluentImpl(){
    
}
public JobStatusFluentImpl( JobStatus instance ){
    this.withActive(instance.getActive()); this.withCompletionTime(instance.getCompletionTime()); this.withConditions(instance.getConditions()); this.withFailed(instance.getFailed()); this.withStartTime(instance.getStartTime()); this.withSucceeded(instance.getSucceeded()); 
}

    public Integer getActive(){
    return this.active;
    }
    public T withActive( Integer active){
    this.active=active; return (T) this;
    }
    public String getCompletionTime(){
    return this.completionTime;
    }
    public T withCompletionTime( String completionTime){
    this.completionTime=completionTime; return (T) this;
    }
    public T addToConditions( JobCondition ...items){
    for (JobCondition item : items) {JobConditionBuilder builder = new JobConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (T)this;
    }
    public T removeFromConditions( JobCondition ...items){
    for (JobCondition item : items) {JobConditionBuilder builder = new JobConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (T)this;
    }
    public List<JobCondition> getConditions(){
    return build(conditions);
    }
    public T withConditions( List<JobCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (JobCondition item : conditions){this.addToConditions(item);}} return (T) this;
    }
    public T withConditions( JobCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (JobCondition item :conditions){ this.addToConditions(item);}} return (T) this;
    }
    public ConditionsNested<T> addNewCondition(){
    return new ConditionsNestedImpl<T>();
    }
    public ConditionsNested<T> addNewConditionLike( JobCondition item){
    return new ConditionsNestedImpl<T>(item);
    }
    public Integer getFailed(){
    return this.failed;
    }
    public T withFailed( Integer failed){
    this.failed=failed; return (T) this;
    }
    public String getStartTime(){
    return this.startTime;
    }
    public T withStartTime( String startTime){
    this.startTime=startTime; return (T) this;
    }
    public Integer getSucceeded(){
    return this.succeeded;
    }
    public T withSucceeded( Integer succeeded){
    this.succeeded=succeeded; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
JobStatusFluentImpl that = (JobStatusFluentImpl) o;
if (active != null ? !active.equals(that.active) :that.active != null) return false;
if (completionTime != null ? !completionTime.equals(that.completionTime) :that.completionTime != null) return false;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (failed != null ? !failed.equals(that.failed) :that.failed != null) return false;
if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
if (succeeded != null ? !succeeded.equals(that.succeeded) :that.succeeded != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConditionsNestedImpl<N> extends JobConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final JobConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new JobConditionBuilder(this);
        }
             ConditionsNestedImpl ( JobCondition item){
        this.builder = new JobConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) JobStatusFluentImpl.this.addToConditions(builder.build());
        }
    
}


}
