package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class SELinuxContextStrategyOptionsFluentImpl<T extends SELinuxContextStrategyOptionsFluent<T>> extends BaseFluent<T> implements SELinuxContextStrategyOptionsFluent<T>{

     VisitableBuilder<SELinuxOptions, ?> seLinuxOptions;     String type;     Map<String, Object> additionalProperties = new HashMap();
public SELinuxContextStrategyOptionsFluentImpl(){
    
}
public SELinuxContextStrategyOptionsFluentImpl( SELinuxContextStrategyOptions instance ){
    this.withSeLinuxOptions(instance.getSeLinuxOptions()); this.withType(instance.getType()); 
}

    public SELinuxOptions getSeLinuxOptions(){
    return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }
    public T withSeLinuxOptions( SELinuxOptions seLinuxOptions){
    if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.add(this.seLinuxOptions);} return (T) this;
    }
    public SeLinuxOptionsNested<T> withNewSeLinuxOptions(){
    return new SeLinuxOptionsNestedImpl<T>();
    }
    public SeLinuxOptionsNested<T> withNewSeLinuxOptionsLike( SELinuxOptions item){
    return new SeLinuxOptionsNestedImpl<T>(item);
    }
    public SeLinuxOptionsNested<T> editSeLinuxOptions(){
    return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }
    public T withNewSeLinuxOptions( String level,  String role,  String type,  String user){
    return withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SELinuxContextStrategyOptionsFluentImpl that = (SELinuxContextStrategyOptionsFluentImpl) o;
if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SeLinuxOptionsNestedImpl<N> extends SELinuxOptionsFluentImpl<SeLinuxOptionsNested<N>> implements SeLinuxOptionsNested<N>{

        private final SELinuxOptionsBuilder builder;
    
             SeLinuxOptionsNestedImpl (){
        this.builder = new SELinuxOptionsBuilder(this);
        }
             SeLinuxOptionsNestedImpl ( SELinuxOptions item){
        this.builder = new SELinuxOptionsBuilder(this, item);
        }
    
            public N endSeLinuxOptions(){
            return and();
        }
            public N and(){
            return (N) SELinuxContextStrategyOptionsFluentImpl.this.withSeLinuxOptions(builder.build());
        }
    
}


}
