package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ReplicationControllerFluent<T extends ReplicationControllerFluent<T>> extends Fluent<T>{


    public ReplicationController.ApiVersion getApiVersion();    public T withApiVersion( ReplicationController.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public ReplicationControllerSpec getSpec();    public T withSpec( ReplicationControllerSpec spec);    public SpecNested<T> withNewSpec();    public SpecNested<T> withNewSpecLike( ReplicationControllerSpec item);    public SpecNested<T> editSpec();    public ReplicationControllerStatus getStatus();    public T withStatus( ReplicationControllerStatus status);    public StatusNested<T> withNewStatus();    public StatusNested<T> withNewStatusLike( ReplicationControllerStatus item);    public StatusNested<T> editStatus();    public T withNewStatus( Long observedGeneration,  Integer replicas);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>, ReplicationControllerSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>, ReplicationControllerStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
