package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class PodTemplateFluentImpl<T extends PodTemplateFluent<T>> extends BaseFluent<T> implements PodTemplateFluent<T>{

     PodTemplate.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<PodTemplateSpec, ?> template;     Map<String, Object> additionalProperties = new HashMap();
public PodTemplateFluentImpl(){
    
}
public PodTemplateFluentImpl( PodTemplate instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withTemplate(instance.getTemplate()); 
}

    public PodTemplate.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( PodTemplate.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public T withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (T) this;
    }
    public TemplateNested<T> withNewTemplate(){
    return new TemplateNestedImpl<T>();
    }
    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNestedImpl<T>(item);
    }
    public TemplateNested<T> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodTemplateFluentImpl that = (PodTemplateFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (template != null ? !template.equals(that.template) :that.template != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) PodTemplateFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<TemplateNested<N>> implements TemplateNested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNestedImpl (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
             TemplateNestedImpl ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
    
            public N endTemplate(){
            return and();
        }
            public N and(){
            return (N) PodTemplateFluentImpl.this.withTemplate(builder.build());
        }
    
}


}
