package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface PodSpecFluent<T extends PodSpecFluent<T>> extends Fluent<T>{


    public Long getActiveDeadlineSeconds();    public T withActiveDeadlineSeconds( Long activeDeadlineSeconds);    public T addToContainers( Container ...items);    public T removeFromContainers( Container ...items);    public List<Container> getContainers();    public T withContainers( List<Container> containers);    public T withContainers( Container ...containers);    public ContainersNested<T> addNewContainer();    public ContainersNested<T> addNewContainerLike( Container item);    public String getDnsPolicy();    public T withDnsPolicy( String dnsPolicy);    public String getHost();    public T withHost( String host);    public Boolean isHostIPC();    public T withHostIPC( Boolean hostIPC);    public Boolean isHostNetwork();    public T withHostNetwork( Boolean hostNetwork);    public Boolean isHostPID();    public T withHostPID( Boolean hostPID);    public T addToImagePullSecrets( LocalObjectReference ...items);    public T removeFromImagePullSecrets( LocalObjectReference ...items);    public List<LocalObjectReference> getImagePullSecrets();    public T withImagePullSecrets( List<LocalObjectReference> imagePullSecrets);    public T withImagePullSecrets( LocalObjectReference ...imagePullSecrets);    public ImagePullSecretsNested<T> addNewImagePullSecret();    public ImagePullSecretsNested<T> addNewImagePullSecretLike( LocalObjectReference item);    public T addNewImagePullSecret( String name);    public String getNodeName();    public T withNodeName( String nodeName);    public T addToNodeSelector( String key,  String value);    public T addToNodeSelector( Map<String, String> map);    public T removeFromNodeSelector( String key);    public T removeFromNodeSelector( Map<String, String> map);    public Map<String, String> getNodeSelector();    public T withNodeSelector( Map<String, String> nodeSelector);    public String getRestartPolicy();    public T withRestartPolicy( String restartPolicy);    public PodSecurityContext getSecurityContext();    public T withSecurityContext( PodSecurityContext securityContext);    public SecurityContextNested<T> withNewSecurityContext();    public SecurityContextNested<T> withNewSecurityContextLike( PodSecurityContext item);    public SecurityContextNested<T> editSecurityContext();    public String getServiceAccount();    public T withServiceAccount( String serviceAccount);    public String getServiceAccountName();    public T withServiceAccountName( String serviceAccountName);    public Long getTerminationGracePeriodSeconds();    public T withTerminationGracePeriodSeconds( Long terminationGracePeriodSeconds);    public T addToVolumes( Volume ...items);    public T removeFromVolumes( Volume ...items);    public List<Volume> getVolumes();    public T withVolumes( List<Volume> volumes);    public T withVolumes( Volume ...volumes);    public VolumesNested<T> addNewVolume();    public VolumesNested<T> addNewVolumeLike( Volume item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ContainersNested<N> extends Nested<N>, ContainerFluent<ContainersNested<N>>{
            public N and();            public N endContainer();        
}

    public interface ImagePullSecretsNested<N> extends Nested<N>, LocalObjectReferenceFluent<ImagePullSecretsNested<N>>{
            public N and();            public N endImagePullSecret();        
}

    public interface SecurityContextNested<N> extends Nested<N>, PodSecurityContextFluent<SecurityContextNested<N>>{
            public N and();            public N endSecurityContext();        
}

    public interface VolumesNested<N> extends Nested<N>, VolumeFluent<VolumesNested<N>>{
            public N and();            public N endVolume();        
}


}
