package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class PodSecurityContextFluentImpl<T extends PodSecurityContextFluent<T>> extends BaseFluent<T> implements PodSecurityContextFluent<T>{

     Long fsGroup;     Boolean runAsNonRoot;     Long runAsUser;     VisitableBuilder<SELinuxOptions, ?> seLinuxOptions;     List<Long> supplementalGroups = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public PodSecurityContextFluentImpl(){
    
}
public PodSecurityContextFluentImpl( PodSecurityContext instance ){
    this.withFsGroup(instance.getFsGroup()); this.withRunAsNonRoot(instance.getRunAsNonRoot()); this.withRunAsUser(instance.getRunAsUser()); this.withSeLinuxOptions(instance.getSeLinuxOptions()); this.withSupplementalGroups(instance.getSupplementalGroups()); 
}

    public Long getFsGroup(){
    return this.fsGroup;
    }
    public T withFsGroup( Long fsGroup){
    this.fsGroup=fsGroup; return (T) this;
    }
    public Boolean isRunAsNonRoot(){
    return this.runAsNonRoot;
    }
    public T withRunAsNonRoot( Boolean runAsNonRoot){
    this.runAsNonRoot=runAsNonRoot; return (T) this;
    }
    public Long getRunAsUser(){
    return this.runAsUser;
    }
    public T withRunAsUser( Long runAsUser){
    this.runAsUser=runAsUser; return (T) this;
    }
    public SELinuxOptions getSeLinuxOptions(){
    return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }
    public T withSeLinuxOptions( SELinuxOptions seLinuxOptions){
    if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.add(this.seLinuxOptions);} return (T) this;
    }
    public SeLinuxOptionsNested<T> withNewSeLinuxOptions(){
    return new SeLinuxOptionsNestedImpl<T>();
    }
    public SeLinuxOptionsNested<T> withNewSeLinuxOptionsLike( SELinuxOptions item){
    return new SeLinuxOptionsNestedImpl<T>(item);
    }
    public SeLinuxOptionsNested<T> editSeLinuxOptions(){
    return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }
    public T withNewSeLinuxOptions( String level,  String role,  String type,  String user){
    return withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }
    public T addToSupplementalGroups( Long ...items){
    for (Long item : items) {this.supplementalGroups.add(item);} return (T)this;
    }
    public T removeFromSupplementalGroups( Long ...items){
    for (Long item : items) {this.supplementalGroups.remove(item);} return (T)this;
    }
    public List<Long> getSupplementalGroups(){
    return this.supplementalGroups;
    }
    public T withSupplementalGroups( List<Long> supplementalGroups){
    this.supplementalGroups.clear();if (supplementalGroups != null) {for (Long item : supplementalGroups){this.addToSupplementalGroups(item);}} return (T) this;
    }
    public T withSupplementalGroups( Long ...supplementalGroups){
    this.supplementalGroups.clear(); if (supplementalGroups != null) {for (Long item :supplementalGroups){ this.addToSupplementalGroups(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodSecurityContextFluentImpl that = (PodSecurityContextFluentImpl) o;
if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
if (runAsNonRoot != null ? !runAsNonRoot.equals(that.runAsNonRoot) :that.runAsNonRoot != null) return false;
if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SeLinuxOptionsNestedImpl<N> extends SELinuxOptionsFluentImpl<SeLinuxOptionsNested<N>> implements SeLinuxOptionsNested<N>{

        private final SELinuxOptionsBuilder builder;
    
             SeLinuxOptionsNestedImpl (){
        this.builder = new SELinuxOptionsBuilder(this);
        }
             SeLinuxOptionsNestedImpl ( SELinuxOptions item){
        this.builder = new SELinuxOptionsBuilder(this, item);
        }
    
            public N endSeLinuxOptions(){
            return and();
        }
            public N and(){
            return (N) PodSecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
        }
    
}


}
