package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NamespaceListFluent<T extends NamespaceListFluent<T>> extends Fluent<T>{


    public NamespaceList.ApiVersion getApiVersion();    public T withApiVersion( NamespaceList.ApiVersion apiVersion);    public T addToItems( Namespace ...items);    public T removeFromItems( Namespace ...items);    public List<Namespace> getItems();    public T withItems( List<Namespace> items);    public T withItems( Namespace ...items);    public ItemsNested<T> addNewItem();    public ItemsNested<T> addNewItemLike( Namespace item);    public String getKind();    public T withKind( String kind);    public ListMeta getMetadata();    public T withMetadata( ListMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ListMeta item);    public MetadataNested<T> editMetadata();    public T withNewMetadata( String resourceVersion,  String selfLink);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ItemsNested<N> extends Nested<N>, NamespaceFluent<ItemsNested<N>>{
            public N endItem();            public N and();        
}

    public interface MetadataNested<N> extends Nested<N>, ListMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
