/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.DeploymentConfigStatusBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class DeploymentConfigFluentImpl<T extends DeploymentConfigFluent<T>>
extends BaseFluent<T>
implements DeploymentConfigFluent<T> {
    DeploymentConfig.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<DeploymentConfigSpec, ?> spec;
    VisitableBuilder<DeploymentConfigStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public DeploymentConfigFluentImpl() {
    }

    public DeploymentConfigFluentImpl(DeploymentConfig instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public DeploymentConfig.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(DeploymentConfig.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DeploymentConfigSpec getSpec() {
        return this.spec != null ? (DeploymentConfigSpec)this.spec.build() : null;
    }

    @Override
    public T withSpec(DeploymentConfigSpec spec) {
        if (spec != null) {
            this.spec = new DeploymentConfigSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    @Override
    public DeploymentConfigFluent.SpecNested<T> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DeploymentConfigFluent.SpecNested<T> withNewSpecLike(DeploymentConfigSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DeploymentConfigFluent.SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DeploymentConfigStatus getStatus() {
        return this.status != null ? (DeploymentConfigStatus)this.status.build() : null;
    }

    @Override
    public T withStatus(DeploymentConfigStatus status) {
        if (status != null) {
            this.status = new DeploymentConfigStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    @Override
    public DeploymentConfigFluent.StatusNested<T> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DeploymentConfigFluent.StatusNested<T> withNewStatusLike(DeploymentConfigStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DeploymentConfigFluent.StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentConfigFluentImpl that = (DeploymentConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNestedImpl<N>
    extends DeploymentConfigStatusFluentImpl<DeploymentConfigFluent.StatusNested<N>>
    implements DeploymentConfigFluent.StatusNested<N> {
        private final DeploymentConfigStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new DeploymentConfigStatusBuilder(this);
        }

        StatusNestedImpl(DeploymentConfigStatus item) {
            this.builder = new DeploymentConfigStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends DeploymentConfigSpecFluentImpl<DeploymentConfigFluent.SpecNested<N>>
    implements DeploymentConfigFluent.SpecNested<N> {
        private final DeploymentConfigSpecBuilder builder;

        SpecNestedImpl(DeploymentConfigSpec item) {
            this.builder = new DeploymentConfigSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new DeploymentConfigSpecBuilder(this);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DeploymentConfigFluent.MetadataNested<N>>
    implements DeploymentConfigFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

