package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface VolumeFluent<T extends VolumeFluent<T>> extends Fluent<T>{


    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore();    public T withAwsElasticBlockStore( AWSElasticBlockStoreVolumeSource awsElasticBlockStore);    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore();    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike( AWSElasticBlockStoreVolumeSource item);    public AwsElasticBlockStoreNested<T> editAwsElasticBlockStore();    public T withNewAwsElasticBlockStore( String fsType,  Integer partition,  Boolean readOnly,  String volumeID);    public CephFSVolumeSource getCephfs();    public T withCephfs( CephFSVolumeSource cephfs);    public CephfsNested<T> withNewCephfs();    public CephfsNested<T> withNewCephfsLike( CephFSVolumeSource item);    public CephfsNested<T> editCephfs();    public CinderVolumeSource getCinder();    public T withCinder( CinderVolumeSource cinder);    public CinderNested<T> withNewCinder();    public CinderNested<T> withNewCinderLike( CinderVolumeSource item);    public CinderNested<T> editCinder();    public T withNewCinder( String fsType,  Boolean readOnly,  String volumeID);    public DownwardAPIVolumeSource getDownwardAPI();    public T withDownwardAPI( DownwardAPIVolumeSource downwardAPI);    public DownwardAPINested<T> withNewDownwardAPI();    public DownwardAPINested<T> withNewDownwardAPILike( DownwardAPIVolumeSource item);    public DownwardAPINested<T> editDownwardAPI();    public EmptyDirVolumeSource getEmptyDir();    public T withEmptyDir( EmptyDirVolumeSource emptyDir);    public EmptyDirNested<T> withNewEmptyDir();    public EmptyDirNested<T> withNewEmptyDirLike( EmptyDirVolumeSource item);    public EmptyDirNested<T> editEmptyDir();    public T withNewEmptyDir( String medium);    public FCVolumeSource getFc();    public T withFc( FCVolumeSource fc);    public FcNested<T> withNewFc();    public FcNested<T> withNewFcLike( FCVolumeSource item);    public FcNested<T> editFc();    public FlockerVolumeSource getFlocker();    public T withFlocker( FlockerVolumeSource flocker);    public FlockerNested<T> withNewFlocker();    public FlockerNested<T> withNewFlockerLike( FlockerVolumeSource item);    public FlockerNested<T> editFlocker();    public T withNewFlocker( String datasetName);    public GCEPersistentDiskVolumeSource getGcePersistentDisk();    public T withGcePersistentDisk( GCEPersistentDiskVolumeSource gcePersistentDisk);    public GcePersistentDiskNested<T> withNewGcePersistentDisk();    public GcePersistentDiskNested<T> withNewGcePersistentDiskLike( GCEPersistentDiskVolumeSource item);    public GcePersistentDiskNested<T> editGcePersistentDisk();    public T withNewGcePersistentDisk( String fsType,  Integer partition,  String pdName,  Boolean readOnly);    public GitRepoVolumeSource getGitRepo();    public T withGitRepo( GitRepoVolumeSource gitRepo);    public GitRepoNested<T> withNewGitRepo();    public GitRepoNested<T> withNewGitRepoLike( GitRepoVolumeSource item);    public GitRepoNested<T> editGitRepo();    public T withNewGitRepo( String repository,  String revision);    public GlusterfsVolumeSource getGlusterfs();    public T withGlusterfs( GlusterfsVolumeSource glusterfs);    public GlusterfsNested<T> withNewGlusterfs();    public GlusterfsNested<T> withNewGlusterfsLike( GlusterfsVolumeSource item);    public GlusterfsNested<T> editGlusterfs();    public T withNewGlusterfs( String endpoints,  String path,  Boolean readOnly);    public HostPathVolumeSource getHostPath();    public T withHostPath( HostPathVolumeSource hostPath);    public HostPathNested<T> withNewHostPath();    public HostPathNested<T> withNewHostPathLike( HostPathVolumeSource item);    public HostPathNested<T> editHostPath();    public T withNewHostPath( String path);    public ISCSIVolumeSource getIscsi();    public T withIscsi( ISCSIVolumeSource iscsi);    public IscsiNested<T> withNewIscsi();    public IscsiNested<T> withNewIscsiLike( ISCSIVolumeSource item);    public IscsiNested<T> editIscsi();    public T withNewIscsi( String fsType,  String iqn,  Integer lun,  Boolean readOnly,  String targetPortal);    public MetadataVolumeSource getMetadata();    public T withMetadata( MetadataVolumeSource metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( MetadataVolumeSource item);    public MetadataNested<T> editMetadata();    public String getName();    public T withName( String name);    public NFSVolumeSource getNfs();    public T withNfs( NFSVolumeSource nfs);    public NfsNested<T> withNewNfs();    public NfsNested<T> withNewNfsLike( NFSVolumeSource item);    public NfsNested<T> editNfs();    public T withNewNfs( String path,  Boolean readOnly,  String server);    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim();    public T withPersistentVolumeClaim( PersistentVolumeClaimVolumeSource persistentVolumeClaim);    public PersistentVolumeClaimNested<T> withNewPersistentVolumeClaim();    public PersistentVolumeClaimNested<T> withNewPersistentVolumeClaimLike( PersistentVolumeClaimVolumeSource item);    public PersistentVolumeClaimNested<T> editPersistentVolumeClaim();    public T withNewPersistentVolumeClaim( String claimName,  Boolean readOnly);    public RBDVolumeSource getRbd();    public T withRbd( RBDVolumeSource rbd);    public RbdNested<T> withNewRbd();    public RbdNested<T> withNewRbdLike( RBDVolumeSource item);    public RbdNested<T> editRbd();    public SecretVolumeSource getSecret();    public T withSecret( SecretVolumeSource secret);    public SecretNested<T> withNewSecret();    public SecretNested<T> withNewSecretLike( SecretVolumeSource item);    public SecretNested<T> editSecret();    public T withNewSecret( String secretName);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface AwsElasticBlockStoreNested<N> extends Nested<N>, AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>>{
            public N endAwsElasticBlockStore();            public N and();        
}

    public interface CephfsNested<N> extends Nested<N>, CephFSVolumeSourceFluent<CephfsNested<N>>{
            public N endCephfs();            public N and();        
}

    public interface CinderNested<N> extends Nested<N>, CinderVolumeSourceFluent<CinderNested<N>>{
            public N and();            public N endCinder();        
}

    public interface DownwardAPINested<N> extends Nested<N>, DownwardAPIVolumeSourceFluent<DownwardAPINested<N>>{
            public N endDownwardAPI();            public N and();        
}

    public interface EmptyDirNested<N> extends Nested<N>, EmptyDirVolumeSourceFluent<EmptyDirNested<N>>{
            public N endEmptyDir();            public N and();        
}

    public interface FcNested<N> extends Nested<N>, FCVolumeSourceFluent<FcNested<N>>{
            public N and();            public N endFc();        
}

    public interface FlockerNested<N> extends Nested<N>, FlockerVolumeSourceFluent<FlockerNested<N>>{
            public N and();            public N endFlocker();        
}

    public interface GcePersistentDiskNested<N> extends Nested<N>, GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>>{
            public N endGcePersistentDisk();            public N and();        
}

    public interface GitRepoNested<N> extends Nested<N>, GitRepoVolumeSourceFluent<GitRepoNested<N>>{
            public N endGitRepo();            public N and();        
}

    public interface GlusterfsNested<N> extends Nested<N>, GlusterfsVolumeSourceFluent<GlusterfsNested<N>>{
            public N and();            public N endGlusterfs();        
}

    public interface HostPathNested<N> extends Nested<N>, HostPathVolumeSourceFluent<HostPathNested<N>>{
            public N and();            public N endHostPath();        
}

    public interface IscsiNested<N> extends Nested<N>, ISCSIVolumeSourceFluent<IscsiNested<N>>{
            public N and();            public N endIscsi();        
}

    public interface MetadataNested<N> extends Nested<N>, MetadataVolumeSourceFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface NfsNested<N> extends Nested<N>, NFSVolumeSourceFluent<NfsNested<N>>{
            public N endNfs();            public N and();        
}

    public interface PersistentVolumeClaimNested<N> extends Nested<N>, PersistentVolumeClaimVolumeSourceFluent<PersistentVolumeClaimNested<N>>{
            public N endPersistentVolumeClaim();            public N and();        
}

    public interface RbdNested<N> extends Nested<N>, RBDVolumeSourceFluent<RbdNested<N>>{
            public N and();            public N endRbd();        
}

    public interface SecretNested<N> extends Nested<N>, SecretVolumeSourceFluent<SecretNested<N>>{
            public N and();            public N endSecret();        
}


}
