package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DeleteOptionsFluentImpl<T extends DeleteOptionsFluent<T>> extends BaseFluent<T> implements DeleteOptionsFluent<T>{

     DeleteOptions.ApiVersion apiVersion;     Long gracePeriodSeconds;     String kind;     Map<String, Object> additionalProperties = new HashMap();
public DeleteOptionsFluentImpl(){
    
}
public DeleteOptionsFluentImpl( DeleteOptions instance ){
    this.withApiVersion(instance.getApiVersion()); this.withGracePeriodSeconds(instance.getGracePeriodSeconds()); this.withKind(instance.getKind()); 
}

    public DeleteOptions.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( DeleteOptions.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public Long getGracePeriodSeconds(){
    return this.gracePeriodSeconds;
    }
    public T withGracePeriodSeconds( Long gracePeriodSeconds){
    this.gracePeriodSeconds=gracePeriodSeconds; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeleteOptionsFluentImpl that = (DeleteOptionsFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (gracePeriodSeconds != null ? !gracePeriodSeconds.equals(that.gracePeriodSeconds) :that.gracePeriodSeconds != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
