package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class OAuthAuthorizeTokenFluentImpl<T extends OAuthAuthorizeTokenFluent<T>> extends BaseFluent<T> implements OAuthAuthorizeTokenFluent<T>{

     OAuthAuthorizeToken.ApiVersion apiVersion;     String clientName;     Long expiresIn;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     String redirectURI;     List<String> scopes = new ArrayList();     String state;     String userName;     String userUID;     Map<String, Object> additionalProperties = new HashMap();
public OAuthAuthorizeTokenFluentImpl(){
    
}
public OAuthAuthorizeTokenFluentImpl( OAuthAuthorizeToken instance ){
    this.withApiVersion(instance.getApiVersion()); this.withClientName(instance.getClientName()); this.withExpiresIn(instance.getExpiresIn()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRedirectURI(instance.getRedirectURI()); this.withScopes(instance.getScopes()); this.withState(instance.getState()); this.withUserName(instance.getUserName()); this.withUserUID(instance.getUserUID()); 
}

    public OAuthAuthorizeToken.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( OAuthAuthorizeToken.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getClientName(){
    return this.clientName;
    }
    public T withClientName( String clientName){
    this.clientName=clientName; return (T) this;
    }
    public Long getExpiresIn(){
    return this.expiresIn;
    }
    public T withExpiresIn( Long expiresIn){
    this.expiresIn=expiresIn; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getRedirectURI(){
    return this.redirectURI;
    }
    public T withRedirectURI( String redirectURI){
    this.redirectURI=redirectURI; return (T) this;
    }
    public T addToScopes( String ...items){
    for (String item : items) {this.scopes.add(item);} return (T)this;
    }
    public T removeFromScopes( String ...items){
    for (String item : items) {this.scopes.remove(item);} return (T)this;
    }
    public List<String> getScopes(){
    return this.scopes;
    }
    public T withScopes( List<String> scopes){
    this.scopes.clear();if (scopes != null) {for (String item : scopes){this.addToScopes(item);}} return (T) this;
    }
    public T withScopes( String ...scopes){
    this.scopes.clear(); if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (T) this;
    }
    public String getState(){
    return this.state;
    }
    public T withState( String state){
    this.state=state; return (T) this;
    }
    public String getUserName(){
    return this.userName;
    }
    public T withUserName( String userName){
    this.userName=userName; return (T) this;
    }
    public String getUserUID(){
    return this.userUID;
    }
    public T withUserUID( String userUID){
    this.userUID=userUID; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
OAuthAuthorizeTokenFluentImpl that = (OAuthAuthorizeTokenFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (clientName != null ? !clientName.equals(that.clientName) :that.clientName != null) return false;
if (expiresIn != null ? !expiresIn.equals(that.expiresIn) :that.expiresIn != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (redirectURI != null ? !redirectURI.equals(that.redirectURI) :that.redirectURI != null) return false;
if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
if (state != null ? !state.equals(that.state) :that.state != null) return false;
if (userName != null ? !userName.equals(that.userName) :that.userName != null) return false;
if (userUID != null ? !userUID.equals(that.userUID) :that.userUID != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) OAuthAuthorizeTokenFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
