/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CinderVolumeSource;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FCVolumeSource;
import io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FCVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FlockerVolumeSource;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSource;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.MetadataVolumeSource;
import io.fabric8.kubernetes.api.model.MetadataVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.MetadataVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.HashMap;
import java.util.Map;

public class VolumeFluentImpl<T extends VolumeFluent<T>>
extends BaseFluent<T>
implements VolumeFluent<T> {
    VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;
    VisitableBuilder<CephFSVolumeSource, ?> cephfs;
    VisitableBuilder<CinderVolumeSource, ?> cinder;
    VisitableBuilder<DownwardAPIVolumeSource, ?> downwardAPI;
    VisitableBuilder<EmptyDirVolumeSource, ?> emptyDir;
    VisitableBuilder<FCVolumeSource, ?> fc;
    VisitableBuilder<FlockerVolumeSource, ?> flocker;
    VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;
    VisitableBuilder<GitRepoVolumeSource, ?> gitRepo;
    VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;
    VisitableBuilder<HostPathVolumeSource, ?> hostPath;
    VisitableBuilder<ISCSIVolumeSource, ?> iscsi;
    VisitableBuilder<MetadataVolumeSource, ?> metadata;
    String name;
    VisitableBuilder<NFSVolumeSource, ?> nfs;
    VisitableBuilder<PersistentVolumeClaimVolumeSource, ?> persistentVolumeClaim;
    VisitableBuilder<RBDVolumeSource, ?> rbd;
    VisitableBuilder<SecretVolumeSource, ?> secret;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public VolumeFluentImpl() {
    }

    public VolumeFluentImpl(Volume instance) {
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withDownwardAPI(instance.getDownwardAPI());
        this.withEmptyDir(instance.getEmptyDir());
        this.withFc(instance.getFc());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGitRepo(instance.getGitRepo());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withMetadata(instance.getMetadata());
        this.withName(instance.getName());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withRbd(instance.getRbd());
        this.withSecret(instance.getSecret());
    }

    @Override
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? (AWSElasticBlockStoreVolumeSource)this.awsElasticBlockStore.build() : null;
    }

    @Override
    public T withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        if (awsElasticBlockStore != null) {
            this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
            this._visitables.add(this.awsElasticBlockStore);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore() {
        return new AwsElasticBlockStoreNestedImpl();
    }

    @Override
    public VolumeFluent.AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return new AwsElasticBlockStoreNestedImpl(item);
    }

    @Override
    public VolumeFluent.AwsElasticBlockStoreNested<T> editAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore());
    }

    @Override
    public T withNewAwsElasticBlockStore(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        return this.withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    @Override
    public CephFSVolumeSource getCephfs() {
        return this.cephfs != null ? (CephFSVolumeSource)this.cephfs.build() : null;
    }

    @Override
    public T withCephfs(CephFSVolumeSource cephfs) {
        if (cephfs != null) {
            this.cephfs = new CephFSVolumeSourceBuilder(cephfs);
            this._visitables.add(this.cephfs);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.CephfsNested<T> withNewCephfs() {
        return new CephfsNestedImpl();
    }

    @Override
    public VolumeFluent.CephfsNested<T> withNewCephfsLike(CephFSVolumeSource item) {
        return new CephfsNestedImpl(item);
    }

    @Override
    public VolumeFluent.CephfsNested<T> editCephfs() {
        return this.withNewCephfsLike(this.getCephfs());
    }

    @Override
    public CinderVolumeSource getCinder() {
        return this.cinder != null ? (CinderVolumeSource)this.cinder.build() : null;
    }

    @Override
    public T withCinder(CinderVolumeSource cinder) {
        if (cinder != null) {
            this.cinder = new CinderVolumeSourceBuilder(cinder);
            this._visitables.add(this.cinder);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.CinderNested<T> withNewCinder() {
        return new CinderNestedImpl();
    }

    @Override
    public VolumeFluent.CinderNested<T> withNewCinderLike(CinderVolumeSource item) {
        return new CinderNestedImpl(item);
    }

    @Override
    public VolumeFluent.CinderNested<T> editCinder() {
        return this.withNewCinderLike(this.getCinder());
    }

    @Override
    public T withNewCinder(String fsType, Boolean readOnly, String volumeID) {
        return this.withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }

    @Override
    public DownwardAPIVolumeSource getDownwardAPI() {
        return this.downwardAPI != null ? (DownwardAPIVolumeSource)this.downwardAPI.build() : null;
    }

    @Override
    public T withDownwardAPI(DownwardAPIVolumeSource downwardAPI) {
        if (downwardAPI != null) {
            this.downwardAPI = new DownwardAPIVolumeSourceBuilder(downwardAPI);
            this._visitables.add(this.downwardAPI);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.DownwardAPINested<T> withNewDownwardAPI() {
        return new DownwardAPINestedImpl();
    }

    @Override
    public VolumeFluent.DownwardAPINested<T> withNewDownwardAPILike(DownwardAPIVolumeSource item) {
        return new DownwardAPINestedImpl(item);
    }

    @Override
    public VolumeFluent.DownwardAPINested<T> editDownwardAPI() {
        return this.withNewDownwardAPILike(this.getDownwardAPI());
    }

    @Override
    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir != null ? (EmptyDirVolumeSource)this.emptyDir.build() : null;
    }

    @Override
    public T withEmptyDir(EmptyDirVolumeSource emptyDir) {
        if (emptyDir != null) {
            this.emptyDir = new EmptyDirVolumeSourceBuilder(emptyDir);
            this._visitables.add(this.emptyDir);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.EmptyDirNested<T> withNewEmptyDir() {
        return new EmptyDirNestedImpl();
    }

    @Override
    public VolumeFluent.EmptyDirNested<T> withNewEmptyDirLike(EmptyDirVolumeSource item) {
        return new EmptyDirNestedImpl(item);
    }

    @Override
    public VolumeFluent.EmptyDirNested<T> editEmptyDir() {
        return this.withNewEmptyDirLike(this.getEmptyDir());
    }

    @Override
    public T withNewEmptyDir(String medium) {
        return this.withEmptyDir(new EmptyDirVolumeSource(medium));
    }

    @Override
    public FCVolumeSource getFc() {
        return this.fc != null ? (FCVolumeSource)this.fc.build() : null;
    }

    @Override
    public T withFc(FCVolumeSource fc) {
        if (fc != null) {
            this.fc = new FCVolumeSourceBuilder(fc);
            this._visitables.add(this.fc);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.FcNested<T> withNewFc() {
        return new FcNestedImpl();
    }

    @Override
    public VolumeFluent.FcNested<T> withNewFcLike(FCVolumeSource item) {
        return new FcNestedImpl(item);
    }

    @Override
    public VolumeFluent.FcNested<T> editFc() {
        return this.withNewFcLike(this.getFc());
    }

    @Override
    public FlockerVolumeSource getFlocker() {
        return this.flocker != null ? (FlockerVolumeSource)this.flocker.build() : null;
    }

    @Override
    public T withFlocker(FlockerVolumeSource flocker) {
        if (flocker != null) {
            this.flocker = new FlockerVolumeSourceBuilder(flocker);
            this._visitables.add(this.flocker);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.FlockerNested<T> withNewFlocker() {
        return new FlockerNestedImpl();
    }

    @Override
    public VolumeFluent.FlockerNested<T> withNewFlockerLike(FlockerVolumeSource item) {
        return new FlockerNestedImpl(item);
    }

    @Override
    public VolumeFluent.FlockerNested<T> editFlocker() {
        return this.withNewFlockerLike(this.getFlocker());
    }

    @Override
    public T withNewFlocker(String datasetName) {
        return this.withFlocker(new FlockerVolumeSource(datasetName));
    }

    @Override
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? (GCEPersistentDiskVolumeSource)this.gcePersistentDisk.build() : null;
    }

    @Override
    public T withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.GcePersistentDiskNested<T> withNewGcePersistentDisk() {
        return new GcePersistentDiskNestedImpl();
    }

    @Override
    public VolumeFluent.GcePersistentDiskNested<T> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return new GcePersistentDiskNestedImpl(item);
    }

    @Override
    public VolumeFluent.GcePersistentDiskNested<T> editGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk());
    }

    @Override
    public T withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    @Override
    public GitRepoVolumeSource getGitRepo() {
        return this.gitRepo != null ? (GitRepoVolumeSource)this.gitRepo.build() : null;
    }

    @Override
    public T withGitRepo(GitRepoVolumeSource gitRepo) {
        if (gitRepo != null) {
            this.gitRepo = new GitRepoVolumeSourceBuilder(gitRepo);
            this._visitables.add(this.gitRepo);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.GitRepoNested<T> withNewGitRepo() {
        return new GitRepoNestedImpl();
    }

    @Override
    public VolumeFluent.GitRepoNested<T> withNewGitRepoLike(GitRepoVolumeSource item) {
        return new GitRepoNestedImpl(item);
    }

    @Override
    public VolumeFluent.GitRepoNested<T> editGitRepo() {
        return this.withNewGitRepoLike(this.getGitRepo());
    }

    @Override
    public T withNewGitRepo(String repository, String revision) {
        return this.withGitRepo(new GitRepoVolumeSource(repository, revision));
    }

    @Override
    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? (GlusterfsVolumeSource)this.glusterfs.build() : null;
    }

    @Override
    public T withGlusterfs(GlusterfsVolumeSource glusterfs) {
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.GlusterfsNested<T> withNewGlusterfs() {
        return new GlusterfsNestedImpl();
    }

    @Override
    public VolumeFluent.GlusterfsNested<T> withNewGlusterfsLike(GlusterfsVolumeSource item) {
        return new GlusterfsNestedImpl(item);
    }

    @Override
    public VolumeFluent.GlusterfsNested<T> editGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs());
    }

    @Override
    public T withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    @Override
    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? (HostPathVolumeSource)this.hostPath.build() : null;
    }

    @Override
    public T withHostPath(HostPathVolumeSource hostPath) {
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.HostPathNested<T> withNewHostPath() {
        return new HostPathNestedImpl();
    }

    @Override
    public VolumeFluent.HostPathNested<T> withNewHostPathLike(HostPathVolumeSource item) {
        return new HostPathNestedImpl(item);
    }

    @Override
    public VolumeFluent.HostPathNested<T> editHostPath() {
        return this.withNewHostPathLike(this.getHostPath());
    }

    @Override
    public T withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    @Override
    public ISCSIVolumeSource getIscsi() {
        return this.iscsi != null ? (ISCSIVolumeSource)this.iscsi.build() : null;
    }

    @Override
    public T withIscsi(ISCSIVolumeSource iscsi) {
        if (iscsi != null) {
            this.iscsi = new ISCSIVolumeSourceBuilder(iscsi);
            this._visitables.add(this.iscsi);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.IscsiNested<T> withNewIscsi() {
        return new IscsiNestedImpl();
    }

    @Override
    public VolumeFluent.IscsiNested<T> withNewIscsiLike(ISCSIVolumeSource item) {
        return new IscsiNestedImpl(item);
    }

    @Override
    public VolumeFluent.IscsiNested<T> editIscsi() {
        return this.withNewIscsiLike(this.getIscsi());
    }

    @Override
    public T withNewIscsi(String fsType, String iqn, Integer lun, Boolean readOnly, String targetPortal) {
        return this.withIscsi(new ISCSIVolumeSource(fsType, iqn, lun, readOnly, targetPortal));
    }

    @Override
    public MetadataVolumeSource getMetadata() {
        return this.metadata != null ? (MetadataVolumeSource)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(MetadataVolumeSource metadata) {
        if (metadata != null) {
            this.metadata = new MetadataVolumeSourceBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public VolumeFluent.MetadataNested<T> withNewMetadataLike(MetadataVolumeSource item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public VolumeFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public NFSVolumeSource getNfs() {
        return this.nfs != null ? (NFSVolumeSource)this.nfs.build() : null;
    }

    @Override
    public T withNfs(NFSVolumeSource nfs) {
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.NfsNested<T> withNewNfs() {
        return new NfsNestedImpl();
    }

    @Override
    public VolumeFluent.NfsNested<T> withNewNfsLike(NFSVolumeSource item) {
        return new NfsNestedImpl(item);
    }

    @Override
    public VolumeFluent.NfsNested<T> editNfs() {
        return this.withNewNfsLike(this.getNfs());
    }

    @Override
    public T withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    @Override
    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null ? (PersistentVolumeClaimVolumeSource)this.persistentVolumeClaim.build() : null;
    }

    @Override
    public T withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
        if (persistentVolumeClaim != null) {
            this.persistentVolumeClaim = new PersistentVolumeClaimVolumeSourceBuilder(persistentVolumeClaim);
            this._visitables.add(this.persistentVolumeClaim);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.PersistentVolumeClaimNested<T> withNewPersistentVolumeClaim() {
        return new PersistentVolumeClaimNestedImpl();
    }

    @Override
    public VolumeFluent.PersistentVolumeClaimNested<T> withNewPersistentVolumeClaimLike(PersistentVolumeClaimVolumeSource item) {
        return new PersistentVolumeClaimNestedImpl(item);
    }

    @Override
    public VolumeFluent.PersistentVolumeClaimNested<T> editPersistentVolumeClaim() {
        return this.withNewPersistentVolumeClaimLike(this.getPersistentVolumeClaim());
    }

    @Override
    public T withNewPersistentVolumeClaim(String claimName, Boolean readOnly) {
        return this.withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
    }

    @Override
    public RBDVolumeSource getRbd() {
        return this.rbd != null ? (RBDVolumeSource)this.rbd.build() : null;
    }

    @Override
    public T withRbd(RBDVolumeSource rbd) {
        if (rbd != null) {
            this.rbd = new RBDVolumeSourceBuilder(rbd);
            this._visitables.add(this.rbd);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.RbdNested<T> withNewRbd() {
        return new RbdNestedImpl();
    }

    @Override
    public VolumeFluent.RbdNested<T> withNewRbdLike(RBDVolumeSource item) {
        return new RbdNestedImpl(item);
    }

    @Override
    public VolumeFluent.RbdNested<T> editRbd() {
        return this.withNewRbdLike(this.getRbd());
    }

    @Override
    public SecretVolumeSource getSecret() {
        return this.secret != null ? (SecretVolumeSource)this.secret.build() : null;
    }

    @Override
    public T withSecret(SecretVolumeSource secret) {
        if (secret != null) {
            this.secret = new SecretVolumeSourceBuilder(secret);
            this._visitables.add(this.secret);
        }
        return (T)this;
    }

    @Override
    public VolumeFluent.SecretNested<T> withNewSecret() {
        return new SecretNestedImpl();
    }

    @Override
    public VolumeFluent.SecretNested<T> withNewSecretLike(SecretVolumeSource item) {
        return new SecretNestedImpl(item);
    }

    @Override
    public VolumeFluent.SecretNested<T> editSecret() {
        return this.withNewSecretLike(this.getSecret());
    }

    @Override
    public T withNewSecret(String secretName) {
        return this.withSecret(new SecretVolumeSource(secretName));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeFluentImpl that = (VolumeFluentImpl)o;
        if (this.awsElasticBlockStore != null ? !this.awsElasticBlockStore.equals(that.awsElasticBlockStore) : that.awsElasticBlockStore != null) {
            return false;
        }
        if (this.cephfs != null ? !this.cephfs.equals(that.cephfs) : that.cephfs != null) {
            return false;
        }
        if (this.cinder != null ? !this.cinder.equals(that.cinder) : that.cinder != null) {
            return false;
        }
        if (this.downwardAPI != null ? !this.downwardAPI.equals(that.downwardAPI) : that.downwardAPI != null) {
            return false;
        }
        if (this.emptyDir != null ? !this.emptyDir.equals(that.emptyDir) : that.emptyDir != null) {
            return false;
        }
        if (this.fc != null ? !this.fc.equals(that.fc) : that.fc != null) {
            return false;
        }
        if (this.flocker != null ? !this.flocker.equals(that.flocker) : that.flocker != null) {
            return false;
        }
        if (this.gcePersistentDisk != null ? !this.gcePersistentDisk.equals(that.gcePersistentDisk) : that.gcePersistentDisk != null) {
            return false;
        }
        if (this.gitRepo != null ? !this.gitRepo.equals(that.gitRepo) : that.gitRepo != null) {
            return false;
        }
        if (this.glusterfs != null ? !this.glusterfs.equals(that.glusterfs) : that.glusterfs != null) {
            return false;
        }
        if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) {
            return false;
        }
        if (this.iscsi != null ? !this.iscsi.equals(that.iscsi) : that.iscsi != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.nfs != null ? !this.nfs.equals(that.nfs) : that.nfs != null) {
            return false;
        }
        if (this.persistentVolumeClaim != null ? !this.persistentVolumeClaim.equals(that.persistentVolumeClaim) : that.persistentVolumeClaim != null) {
            return false;
        }
        if (this.rbd != null ? !this.rbd.equals(that.rbd) : that.rbd != null) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecretNestedImpl<N>
    extends SecretVolumeSourceFluentImpl<VolumeFluent.SecretNested<N>>
    implements VolumeFluent.SecretNested<N> {
        private final SecretVolumeSourceBuilder builder;

        SecretNestedImpl() {
            this.builder = new SecretVolumeSourceBuilder(this);
        }

        SecretNestedImpl(SecretVolumeSource item) {
            this.builder = new SecretVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withSecret(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class RbdNestedImpl<N>
    extends RBDVolumeSourceFluentImpl<VolumeFluent.RbdNested<N>>
    implements VolumeFluent.RbdNested<N> {
        private final RBDVolumeSourceBuilder builder;

        RbdNestedImpl(RBDVolumeSource item) {
            this.builder = new RBDVolumeSourceBuilder(this, item);
        }

        RbdNestedImpl() {
            this.builder = new RBDVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withRbd(this.builder.build());
        }

        @Override
        public N endRbd() {
            return this.and();
        }
    }

    public class PersistentVolumeClaimNestedImpl<N>
    extends PersistentVolumeClaimVolumeSourceFluentImpl<VolumeFluent.PersistentVolumeClaimNested<N>>
    implements VolumeFluent.PersistentVolumeClaimNested<N> {
        private final PersistentVolumeClaimVolumeSourceBuilder builder;

        PersistentVolumeClaimNestedImpl() {
            this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this);
        }

        PersistentVolumeClaimNestedImpl(PersistentVolumeClaimVolumeSource item) {
            this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
        }

        @Override
        public N endPersistentVolumeClaim() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withPersistentVolumeClaim(this.builder.build());
        }
    }

    public class NfsNestedImpl<N>
    extends NFSVolumeSourceFluentImpl<VolumeFluent.NfsNested<N>>
    implements VolumeFluent.NfsNested<N> {
        private final NFSVolumeSourceBuilder builder;

        NfsNestedImpl() {
            this.builder = new NFSVolumeSourceBuilder(this);
        }

        NfsNestedImpl(NFSVolumeSource item) {
            this.builder = new NFSVolumeSourceBuilder(this, item);
        }

        @Override
        public N endNfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withNfs(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends MetadataVolumeSourceFluentImpl<VolumeFluent.MetadataNested<N>>
    implements VolumeFluent.MetadataNested<N> {
        private final MetadataVolumeSourceBuilder builder;

        MetadataNestedImpl() {
            this.builder = new MetadataVolumeSourceBuilder(this);
        }

        MetadataNestedImpl(MetadataVolumeSource item) {
            this.builder = new MetadataVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class IscsiNestedImpl<N>
    extends ISCSIVolumeSourceFluentImpl<VolumeFluent.IscsiNested<N>>
    implements VolumeFluent.IscsiNested<N> {
        private final ISCSIVolumeSourceBuilder builder;

        IscsiNestedImpl() {
            this.builder = new ISCSIVolumeSourceBuilder(this);
        }

        IscsiNestedImpl(ISCSIVolumeSource item) {
            this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withIscsi(this.builder.build());
        }

        @Override
        public N endIscsi() {
            return this.and();
        }
    }

    public class HostPathNestedImpl<N>
    extends HostPathVolumeSourceFluentImpl<VolumeFluent.HostPathNested<N>>
    implements VolumeFluent.HostPathNested<N> {
        private final HostPathVolumeSourceBuilder builder;

        HostPathNestedImpl() {
            this.builder = new HostPathVolumeSourceBuilder(this);
        }

        HostPathNestedImpl(HostPathVolumeSource item) {
            this.builder = new HostPathVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withHostPath(this.builder.build());
        }

        @Override
        public N endHostPath() {
            return this.and();
        }
    }

    public class GlusterfsNestedImpl<N>
    extends GlusterfsVolumeSourceFluentImpl<VolumeFluent.GlusterfsNested<N>>
    implements VolumeFluent.GlusterfsNested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

        GlusterfsNestedImpl() {
            this.builder = new GlusterfsVolumeSourceBuilder(this);
        }

        GlusterfsNestedImpl(GlusterfsVolumeSource item) {
            this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withGlusterfs(this.builder.build());
        }

        @Override
        public N endGlusterfs() {
            return this.and();
        }
    }

    public class GitRepoNestedImpl<N>
    extends GitRepoVolumeSourceFluentImpl<VolumeFluent.GitRepoNested<N>>
    implements VolumeFluent.GitRepoNested<N> {
        private final GitRepoVolumeSourceBuilder builder;

        GitRepoNestedImpl() {
            this.builder = new GitRepoVolumeSourceBuilder(this);
        }

        GitRepoNestedImpl(GitRepoVolumeSource item) {
            this.builder = new GitRepoVolumeSourceBuilder(this, item);
        }

        @Override
        public N endGitRepo() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withGitRepo(this.builder.build());
        }
    }

    public class GcePersistentDiskNestedImpl<N>
    extends GCEPersistentDiskVolumeSourceFluentImpl<VolumeFluent.GcePersistentDiskNested<N>>
    implements VolumeFluent.GcePersistentDiskNested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

        GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item) {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }

        GcePersistentDiskNestedImpl() {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }

        @Override
        public N endGcePersistentDisk() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withGcePersistentDisk(this.builder.build());
        }
    }

    public class FlockerNestedImpl<N>
    extends FlockerVolumeSourceFluentImpl<VolumeFluent.FlockerNested<N>>
    implements VolumeFluent.FlockerNested<N> {
        private final FlockerVolumeSourceBuilder builder;

        FlockerNestedImpl() {
            this.builder = new FlockerVolumeSourceBuilder(this);
        }

        FlockerNestedImpl(FlockerVolumeSource item) {
            this.builder = new FlockerVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withFlocker(this.builder.build());
        }

        @Override
        public N endFlocker() {
            return this.and();
        }
    }

    public class FcNestedImpl<N>
    extends FCVolumeSourceFluentImpl<VolumeFluent.FcNested<N>>
    implements VolumeFluent.FcNested<N> {
        private final FCVolumeSourceBuilder builder;

        FcNestedImpl() {
            this.builder = new FCVolumeSourceBuilder(this);
        }

        FcNestedImpl(FCVolumeSource item) {
            this.builder = new FCVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withFc(this.builder.build());
        }

        @Override
        public N endFc() {
            return this.and();
        }
    }

    public class EmptyDirNestedImpl<N>
    extends EmptyDirVolumeSourceFluentImpl<VolumeFluent.EmptyDirNested<N>>
    implements VolumeFluent.EmptyDirNested<N> {
        private final EmptyDirVolumeSourceBuilder builder;

        EmptyDirNestedImpl(EmptyDirVolumeSource item) {
            this.builder = new EmptyDirVolumeSourceBuilder(this, item);
        }

        EmptyDirNestedImpl() {
            this.builder = new EmptyDirVolumeSourceBuilder(this);
        }

        @Override
        public N endEmptyDir() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withEmptyDir(this.builder.build());
        }
    }

    public class DownwardAPINestedImpl<N>
    extends DownwardAPIVolumeSourceFluentImpl<VolumeFluent.DownwardAPINested<N>>
    implements VolumeFluent.DownwardAPINested<N> {
        private final DownwardAPIVolumeSourceBuilder builder;

        DownwardAPINestedImpl() {
            this.builder = new DownwardAPIVolumeSourceBuilder(this);
        }

        DownwardAPINestedImpl(DownwardAPIVolumeSource item) {
            this.builder = new DownwardAPIVolumeSourceBuilder(this, item);
        }

        @Override
        public N endDownwardAPI() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withDownwardAPI(this.builder.build());
        }
    }

    public class CinderNestedImpl<N>
    extends CinderVolumeSourceFluentImpl<VolumeFluent.CinderNested<N>>
    implements VolumeFluent.CinderNested<N> {
        private final CinderVolumeSourceBuilder builder;

        CinderNestedImpl() {
            this.builder = new CinderVolumeSourceBuilder(this);
        }

        CinderNestedImpl(CinderVolumeSource item) {
            this.builder = new CinderVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withCinder(this.builder.build());
        }

        @Override
        public N endCinder() {
            return this.and();
        }
    }

    public class CephfsNestedImpl<N>
    extends CephFSVolumeSourceFluentImpl<VolumeFluent.CephfsNested<N>>
    implements VolumeFluent.CephfsNested<N> {
        private final CephFSVolumeSourceBuilder builder;

        CephfsNestedImpl(CephFSVolumeSource item) {
            this.builder = new CephFSVolumeSourceBuilder(this, item);
        }

        CephfsNestedImpl() {
            this.builder = new CephFSVolumeSourceBuilder(this);
        }

        @Override
        public N endCephfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withCephfs(this.builder.build());
        }
    }

    public class AwsElasticBlockStoreNestedImpl<N>
    extends AWSElasticBlockStoreVolumeSourceFluentImpl<VolumeFluent.AwsElasticBlockStoreNested<N>>
    implements VolumeFluent.AwsElasticBlockStoreNested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

        AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item) {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }

        AwsElasticBlockStoreNestedImpl() {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }

        @Override
        public N endAwsElasticBlockStore() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluentImpl.this.withAwsElasticBlockStore(this.builder.build());
        }
    }
}

