package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class DeleteOptionsBuilder extends DeleteOptionsFluentImpl<DeleteOptionsBuilder> implements VisitableBuilder<DeleteOptions,DeleteOptionsBuilder>{

     DeleteOptionsFluent<?> fluent;
public DeleteOptionsBuilder(){
    this(new DeleteOptions());
}
public DeleteOptionsBuilder( DeleteOptionsFluent<?> fluent ){
    this(fluent, new DeleteOptions());
}
public DeleteOptionsBuilder( DeleteOptionsFluent<?> fluent , DeleteOptions instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withGracePeriodSeconds(instance.getGracePeriodSeconds()); fluent.withKind(instance.getKind()); 
}
public DeleteOptionsBuilder( DeleteOptions instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withGracePeriodSeconds(instance.getGracePeriodSeconds()); this.withKind(instance.getKind()); 
}

public EditableDeleteOptions build(){
    EditableDeleteOptions buildable = new EditableDeleteOptions(fluent.getApiVersion(),fluent.getGracePeriodSeconds(),fluent.getKind());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DeleteOptionsBuilder that = (DeleteOptionsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
