package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class GitSourceRevisionFluentImpl<T extends GitSourceRevisionFluent<T>> extends BaseFluent<T> implements GitSourceRevisionFluent<T>{

     VisitableBuilder<SourceControlUser, ?> author;     String commit;     VisitableBuilder<SourceControlUser, ?> committer;     String message;     Map<String, Object> additionalProperties = new HashMap();
public GitSourceRevisionFluentImpl(){
    
}
public GitSourceRevisionFluentImpl( GitSourceRevision instance ){
    this.withAuthor(instance.getAuthor()); this.withCommit(instance.getCommit()); this.withCommitter(instance.getCommitter()); this.withMessage(instance.getMessage()); 
}

    public SourceControlUser getAuthor(){
    return this.author!=null?this.author.build():null;
    }
    public T withAuthor( SourceControlUser author){
    if (author!=null){ this.author= new SourceControlUserBuilder(author); _visitables.add(this.author);} return (T) this;
    }
    public AuthorNested<T> withNewAuthor(){
    return new AuthorNestedImpl<T>();
    }
    public AuthorNested<T> withNewAuthorLike( SourceControlUser item){
    return new AuthorNestedImpl<T>(item);
    }
    public AuthorNested<T> editAuthor(){
    return withNewAuthorLike(getAuthor());
    }
    public T withNewAuthor( String email,  String name){
    return withAuthor(new SourceControlUser(email, name));
    }
    public String getCommit(){
    return this.commit;
    }
    public T withCommit( String commit){
    this.commit=commit; return (T) this;
    }
    public SourceControlUser getCommitter(){
    return this.committer!=null?this.committer.build():null;
    }
    public T withCommitter( SourceControlUser committer){
    if (committer!=null){ this.committer= new SourceControlUserBuilder(committer); _visitables.add(this.committer);} return (T) this;
    }
    public CommitterNested<T> withNewCommitter(){
    return new CommitterNestedImpl<T>();
    }
    public CommitterNested<T> withNewCommitterLike( SourceControlUser item){
    return new CommitterNestedImpl<T>(item);
    }
    public CommitterNested<T> editCommitter(){
    return withNewCommitterLike(getCommitter());
    }
    public T withNewCommitter( String email,  String name){
    return withCommitter(new SourceControlUser(email, name));
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
GitSourceRevisionFluentImpl that = (GitSourceRevisionFluentImpl) o;
if (author != null ? !author.equals(that.author) :that.author != null) return false;
if (commit != null ? !commit.equals(that.commit) :that.commit != null) return false;
if (committer != null ? !committer.equals(that.committer) :that.committer != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class AuthorNestedImpl<N> extends SourceControlUserFluentImpl<AuthorNested<N>> implements AuthorNested<N>{

        private final SourceControlUserBuilder builder;
    
             AuthorNestedImpl (){
        this.builder = new SourceControlUserBuilder(this);
        }
             AuthorNestedImpl ( SourceControlUser item){
        this.builder = new SourceControlUserBuilder(this, item);
        }
    
            public N and(){
            return (N) GitSourceRevisionFluentImpl.this.withAuthor(builder.build());
        }
            public N endAuthor(){
            return and();
        }
    
}
    public class CommitterNestedImpl<N> extends SourceControlUserFluentImpl<CommitterNested<N>> implements CommitterNested<N>{

        private final SourceControlUserBuilder builder;
    
             CommitterNestedImpl (){
        this.builder = new SourceControlUserBuilder(this);
        }
             CommitterNestedImpl ( SourceControlUser item){
        this.builder = new SourceControlUserBuilder(this, item);
        }
    
            public N and(){
            return (N) GitSourceRevisionFluentImpl.this.withCommitter(builder.build());
        }
            public N endCommitter(){
            return and();
        }
    
}


}
