package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamedAuthInfoFluentImpl<T extends NamedAuthInfoFluent<T>> extends BaseFluent<T> implements NamedAuthInfoFluent<T>{

     String name;     VisitableBuilder<AuthInfo, ?> user;     Map<String, Object> additionalProperties = new HashMap();
public NamedAuthInfoFluentImpl(){
    
}
public NamedAuthInfoFluentImpl( NamedAuthInfo instance ){
    this.withName(instance.getName()); this.withUser(instance.getUser()); 
}

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public AuthInfo getUser(){
    return this.user!=null?this.user.build():null;
    }
    public T withUser( AuthInfo user){
    if (user!=null){ this.user= new AuthInfoBuilder(user); _visitables.add(this.user);} return (T) this;
    }
    public UserNested<T> withNewUser(){
    return new UserNestedImpl<T>();
    }
    public UserNested<T> withNewUserLike( AuthInfo item){
    return new UserNestedImpl<T>(item);
    }
    public UserNested<T> editUser(){
    return withNewUserLike(getUser());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedAuthInfoFluentImpl that = (NamedAuthInfoFluentImpl) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class UserNestedImpl<N> extends AuthInfoFluentImpl<UserNested<N>> implements UserNested<N>{

        private final AuthInfoBuilder builder;
    
             UserNestedImpl (){
        this.builder = new AuthInfoBuilder(this);
        }
             UserNestedImpl ( AuthInfo item){
        this.builder = new AuthInfoBuilder(this, item);
        }
    
            public N and(){
            return (N) NamedAuthInfoFluentImpl.this.withUser(builder.build());
        }
            public N endUser(){
            return and();
        }
    
}


}
