package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class RouteSpecBuilder extends RouteSpecFluentImpl<RouteSpecBuilder> implements VisitableBuilder<RouteSpec,RouteSpecBuilder>{

     RouteSpecFluent<?> fluent;
public RouteSpecBuilder(){
    this(new RouteSpec());
}
public RouteSpecBuilder( RouteSpecFluent<?> fluent ){
    this(fluent, new RouteSpec());
}
public RouteSpecBuilder( RouteSpecFluent<?> fluent , RouteSpec instance ){
    this.fluent = fluent; fluent.withHost(instance.getHost()); fluent.withPath(instance.getPath()); fluent.withTls(instance.getTls()); fluent.withTo(instance.getTo()); 
}
public RouteSpecBuilder( RouteSpec instance ){
    this.fluent = this; this.withHost(instance.getHost()); this.withPath(instance.getPath()); this.withTls(instance.getTls()); this.withTo(instance.getTo()); 
}

public EditableRouteSpec build(){
    EditableRouteSpec buildable = new EditableRouteSpec(fluent.getHost(),fluent.getPath(),fluent.getTls(),fluent.getTo());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RouteSpecBuilder that = (RouteSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
