
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "activeDeadlineSeconds",
    "containers",
    "dnsPolicy",
    "hostNetwork",
    "imagePullSecrets",
    "nodeName",
    "nodeSelector",
    "restartPolicy",
    "serviceAccountName",
    "terminationGracePeriodSeconds",
    "volumes"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class PodSpec {

    /**
     * 
     * 
     */
    @JsonProperty("activeDeadlineSeconds")
    private Long activeDeadlineSeconds;
    /**
     * list of containers belonging to the pod; cannot be updated; containers cannot currently be added or removed; there must be at least one container in a Pod; see http://releases.k8s.io/v1.0.0/docs/containers.md
     * 
     */
    @JsonProperty("containers")
    @Valid
    private List<Container> containers = new ArrayList<Container>();
    /**
     * DNS policy for containers within the pod; one of 'ClusterFirst' or 'Default'
     * 
     */
    @JsonProperty("dnsPolicy")
    private java.lang.String dnsPolicy;
    /**
     * host networking requested for this pod
     * 
     */
    @JsonProperty("hostNetwork")
    private Boolean hostNetwork;
    /**
     * list of references to secrets in the same namespace available for pulling the container images; see http://releases.k8s.io/v1.0.0/docs/images.md#specifying-imagepullsecrets-on-a-pod
     * 
     */
    @JsonProperty("imagePullSecrets")
    @Valid
    private List<LocalObjectReference> imagePullSecrets = new ArrayList<LocalObjectReference>();
    /**
     * node requested for this pod
     * 
     */
    @JsonProperty("nodeName")
    private java.lang.String nodeName;
    /**
     * selector which must match a node's labels for the pod to be scheduled on that node; see http://releases.k8s.io/v1.0.0/examples/node-selection/README.md
     * 
     */
    @JsonProperty("nodeSelector")
    @Valid
    private Map<String, String> nodeSelector;
    /**
     * restart policy for all containers within the pod; one of Always
     * 
     */
    @JsonProperty("restartPolicy")
    private java.lang.String restartPolicy;
    /**
     * name of the ServiceAccount to use to run this pod; see http://releases.k8s.io/v1.0.0/docs/service_accounts.md
     * 
     */
    @JsonProperty("serviceAccountName")
    private java.lang.String serviceAccountName;
    /**
     * optional duration in seconds the pod needs to terminate gracefully; may be decreased in delete request; value must be non-negative integer; the value zero indicates delete immediately; if this value is not set
     * 
     */
    @JsonProperty("terminationGracePeriodSeconds")
    private Long terminationGracePeriodSeconds;
    /**
     * list of volumes that can be mounted by containers belonging to the pod; see http://releases.k8s.io/v1.0.0/docs/volumes.md
     * 
     */
    @JsonProperty("volumes")
    @Valid
    private List<Volume> volumes = new ArrayList<Volume>();
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PodSpec() {
    }

    /**
     * 
     * @param serviceAccountName
     * @param terminationGracePeriodSeconds
     * @param containers
     * @param hostNetwork
     * @param activeDeadlineSeconds
     * @param nodeName
     * @param dnsPolicy
     * @param volumes
     * @param restartPolicy
     * @param imagePullSecrets
     * @param nodeSelector
     */
    public PodSpec(Long activeDeadlineSeconds, List<Container> containers, java.lang.String dnsPolicy, Boolean hostNetwork, List<LocalObjectReference> imagePullSecrets, java.lang.String nodeName, Map<String, String> nodeSelector, java.lang.String restartPolicy, java.lang.String serviceAccountName, Long terminationGracePeriodSeconds, List<Volume> volumes) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        this.containers = containers;
        this.dnsPolicy = dnsPolicy;
        this.hostNetwork = hostNetwork;
        this.imagePullSecrets = imagePullSecrets;
        this.nodeName = nodeName;
        this.nodeSelector = nodeSelector;
        this.restartPolicy = restartPolicy;
        this.serviceAccountName = serviceAccountName;
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        this.volumes = volumes;
    }

    /**
     * 
     * 
     * @return
     *     The activeDeadlineSeconds
     */
    @JsonProperty("activeDeadlineSeconds")
    public Long getActiveDeadlineSeconds() {
        return activeDeadlineSeconds;
    }

    /**
     * 
     * 
     * @param activeDeadlineSeconds
     *     The activeDeadlineSeconds
     */
    @JsonProperty("activeDeadlineSeconds")
    public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    /**
     * list of containers belonging to the pod; cannot be updated; containers cannot currently be added or removed; there must be at least one container in a Pod; see http://releases.k8s.io/v1.0.0/docs/containers.md
     * 
     * @return
     *     The containers
     */
    @JsonProperty("containers")
    public List<Container> getContainers() {
        return containers;
    }

    /**
     * list of containers belonging to the pod; cannot be updated; containers cannot currently be added or removed; there must be at least one container in a Pod; see http://releases.k8s.io/v1.0.0/docs/containers.md
     * 
     * @param containers
     *     The containers
     */
    @JsonProperty("containers")
    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    /**
     * DNS policy for containers within the pod; one of 'ClusterFirst' or 'Default'
     * 
     * @return
     *     The dnsPolicy
     */
    @JsonProperty("dnsPolicy")
    public java.lang.String getDnsPolicy() {
        return dnsPolicy;
    }

    /**
     * DNS policy for containers within the pod; one of 'ClusterFirst' or 'Default'
     * 
     * @param dnsPolicy
     *     The dnsPolicy
     */
    @JsonProperty("dnsPolicy")
    public void setDnsPolicy(java.lang.String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
    }

    /**
     * host networking requested for this pod
     * 
     * @return
     *     The hostNetwork
     */
    @JsonProperty("hostNetwork")
    public Boolean getHostNetwork() {
        return hostNetwork;
    }

    /**
     * host networking requested for this pod
     * 
     * @param hostNetwork
     *     The hostNetwork
     */
    @JsonProperty("hostNetwork")
    public void setHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    /**
     * list of references to secrets in the same namespace available for pulling the container images; see http://releases.k8s.io/v1.0.0/docs/images.md#specifying-imagepullsecrets-on-a-pod
     * 
     * @return
     *     The imagePullSecrets
     */
    @JsonProperty("imagePullSecrets")
    public List<LocalObjectReference> getImagePullSecrets() {
        return imagePullSecrets;
    }

    /**
     * list of references to secrets in the same namespace available for pulling the container images; see http://releases.k8s.io/v1.0.0/docs/images.md#specifying-imagepullsecrets-on-a-pod
     * 
     * @param imagePullSecrets
     *     The imagePullSecrets
     */
    @JsonProperty("imagePullSecrets")
    public void setImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    /**
     * node requested for this pod
     * 
     * @return
     *     The nodeName
     */
    @JsonProperty("nodeName")
    public java.lang.String getNodeName() {
        return nodeName;
    }

    /**
     * node requested for this pod
     * 
     * @param nodeName
     *     The nodeName
     */
    @JsonProperty("nodeName")
    public void setNodeName(java.lang.String nodeName) {
        this.nodeName = nodeName;
    }

    /**
     * selector which must match a node's labels for the pod to be scheduled on that node; see http://releases.k8s.io/v1.0.0/examples/node-selection/README.md
     * 
     * @return
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public Map<String, String> getNodeSelector() {
        return nodeSelector;
    }

    /**
     * selector which must match a node's labels for the pod to be scheduled on that node; see http://releases.k8s.io/v1.0.0/examples/node-selection/README.md
     * 
     * @param nodeSelector
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    /**
     * restart policy for all containers within the pod; one of Always
     * 
     * @return
     *     The restartPolicy
     */
    @JsonProperty("restartPolicy")
    public java.lang.String getRestartPolicy() {
        return restartPolicy;
    }

    /**
     * restart policy for all containers within the pod; one of Always
     * 
     * @param restartPolicy
     *     The restartPolicy
     */
    @JsonProperty("restartPolicy")
    public void setRestartPolicy(java.lang.String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    /**
     * name of the ServiceAccount to use to run this pod; see http://releases.k8s.io/v1.0.0/docs/service_accounts.md
     * 
     * @return
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public java.lang.String getServiceAccountName() {
        return serviceAccountName;
    }

    /**
     * name of the ServiceAccount to use to run this pod; see http://releases.k8s.io/v1.0.0/docs/service_accounts.md
     * 
     * @param serviceAccountName
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public void setServiceAccountName(java.lang.String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    /**
     * optional duration in seconds the pod needs to terminate gracefully; may be decreased in delete request; value must be non-negative integer; the value zero indicates delete immediately; if this value is not set
     * 
     * @return
     *     The terminationGracePeriodSeconds
     */
    @JsonProperty("terminationGracePeriodSeconds")
    public Long getTerminationGracePeriodSeconds() {
        return terminationGracePeriodSeconds;
    }

    /**
     * optional duration in seconds the pod needs to terminate gracefully; may be decreased in delete request; value must be non-negative integer; the value zero indicates delete immediately; if this value is not set
     * 
     * @param terminationGracePeriodSeconds
     *     The terminationGracePeriodSeconds
     */
    @JsonProperty("terminationGracePeriodSeconds")
    public void setTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
    }

    /**
     * list of volumes that can be mounted by containers belonging to the pod; see http://releases.k8s.io/v1.0.0/docs/volumes.md
     * 
     * @return
     *     The volumes
     */
    @JsonProperty("volumes")
    public List<Volume> getVolumes() {
        return volumes;
    }

    /**
     * list of volumes that can be mounted by containers belonging to the pod; see http://releases.k8s.io/v1.0.0/docs/volumes.md
     * 
     * @param volumes
     *     The volumes
     */
    @JsonProperty("volumes")
    public void setVolumes(List<Volume> volumes) {
        this.volumes = volumes;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
