package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class OAuthAuthorizeTokenBuilder extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenBuilder> implements VisitableBuilder<OAuthAuthorizeToken,OAuthAuthorizeTokenBuilder>{

     OAuthAuthorizeTokenFluent<?> fluent;
public OAuthAuthorizeTokenBuilder(){
    this(new OAuthAuthorizeToken());
}
public OAuthAuthorizeTokenBuilder( OAuthAuthorizeTokenFluent<?> fluent ){
    this(fluent, new OAuthAuthorizeToken());
}
public OAuthAuthorizeTokenBuilder( OAuthAuthorizeTokenFluent<?> fluent , OAuthAuthorizeToken instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withClientName(instance.getClientName()); fluent.withExpiresIn(instance.getExpiresIn()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withRedirectURI(instance.getRedirectURI()); fluent.withScopes(instance.getScopes()); fluent.withState(instance.getState()); fluent.withUserName(instance.getUserName()); fluent.withUserUID(instance.getUserUID()); 
}
public OAuthAuthorizeTokenBuilder( OAuthAuthorizeToken instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withClientName(instance.getClientName()); this.withExpiresIn(instance.getExpiresIn()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRedirectURI(instance.getRedirectURI()); this.withScopes(instance.getScopes()); this.withState(instance.getState()); this.withUserName(instance.getUserName()); this.withUserUID(instance.getUserUID()); 
}

public EditableOAuthAuthorizeToken build(){
    EditableOAuthAuthorizeToken buildable = new EditableOAuthAuthorizeToken(fluent.getApiVersion(),fluent.getClientName(),fluent.getExpiresIn(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURI(),fluent.getScopes(),fluent.getState(),fluent.getUserName(),fluent.getUserUID());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    