/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentCause;
import io.fabric8.openshift.api.model.DeploymentCauseFluent;
import io.fabric8.openshift.api.model.DeploymentCauseFluentImpl;
import io.fabric8.openshift.api.model.EditableDeploymentCause;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentCauseBuilder
extends DeploymentCauseFluentImpl<DeploymentCauseBuilder>
implements VisitableBuilder<DeploymentCause, DeploymentCauseBuilder> {
    DeploymentCauseFluent<?> fluent;

    public DeploymentCauseBuilder() {
        this(new DeploymentCause());
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent) {
        this(fluent, new DeploymentCause());
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent, DeploymentCause instance) {
        this.fluent = fluent;
        fluent.withImageTrigger(instance.getImageTrigger());
        fluent.withType(instance.getType());
    }

    public DeploymentCauseBuilder(DeploymentCause instance) {
        this.fluent = this;
        this.withImageTrigger(instance.getImageTrigger());
        this.withType(instance.getType());
    }

    @Override
    public EditableDeploymentCause build() {
        EditableDeploymentCause buildable = new EditableDeploymentCause(this.fluent.getImageTrigger(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentCauseBuilder that = (DeploymentCauseBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

