/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.ClusterPolicyFluent;
import io.fabric8.openshift.api.model.NamedClusterRole;
import io.fabric8.openshift.api.model.NamedClusterRoleBuilder;
import io.fabric8.openshift.api.model.NamedClusterRoleFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterPolicyFluentImpl<T extends ClusterPolicyFluent<T>>
extends BaseFluent<T>
implements ClusterPolicyFluent<T> {
    ClusterPolicy.ApiVersion apiVersion;
    String kind;
    String lastModified;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<NamedClusterRole, ?>> roles = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public ClusterPolicy.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(ClusterPolicy.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public T withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public ClusterPolicyFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterPolicyFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterPolicyFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T addToRoles(NamedClusterRole ... items) {
        for (NamedClusterRole item : items) {
            NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);
            this._visitables.add(builder);
            this.roles.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromRoles(NamedClusterRole ... items) {
        for (NamedClusterRole item : items) {
            NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);
            this._visitables.remove(builder);
            this.roles.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedClusterRole> getRoles() {
        return this.build(this.roles);
    }

    @Override
    public T withRoles(List<NamedClusterRole> roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedClusterRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withRoles(NamedClusterRole ... roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedClusterRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (T)this;
    }

    @Override
    public ClusterPolicyFluent.RolesNested<T> addNewRole() {
        return new RolesNestedImpl();
    }

    @Override
    public ClusterPolicyFluent.RolesNested<T> addNewRoleLike(NamedClusterRole item) {
        return new RolesNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterPolicyFluentImpl that = (ClusterPolicyFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RolesNestedImpl<N>
    extends NamedClusterRoleFluentImpl<ClusterPolicyFluent.RolesNested<N>>
    implements ClusterPolicyFluent.RolesNested<N> {
        private final NamedClusterRoleBuilder builder;

        RolesNestedImpl() {
            this.builder = new NamedClusterRoleBuilder(this);
        }

        RolesNestedImpl(NamedClusterRole item) {
            this.builder = new NamedClusterRoleBuilder(this, item);
        }

        @Override
        public N endRole() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterPolicyFluentImpl.this.addToRoles(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterPolicyFluent.MetadataNested<N>>
    implements ClusterPolicyFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPolicyFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

