package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface OAuthClientAuthorizationFluent<T extends OAuthClientAuthorizationFluent<T>> extends Fluent<T>{


    public OAuthClientAuthorization.ApiVersion getApiVersion();    public T withApiVersion( OAuthClientAuthorization.ApiVersion apiVersion);    public String getClientName();    public T withClientName( String clientName);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToScopes( String ...items);    public T removeFromScopes( String ...items);    public List<String> getScopes();    public T withScopes( List<String> scopes);    public T withScopes( String ...scopes);    public String getUserName();    public T withUserName( String userName);    public String getUserUID();    public T withUserUID( String userUID);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
