package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamedClusterRoleBindingFluentImpl<T extends NamedClusterRoleBindingFluent<T>> extends BaseFluent<T> implements NamedClusterRoleBindingFluent<T>{

     String name;     VisitableBuilder<ClusterRoleBinding, ?> roleBinding;     Map<String, Object> additionalProperties = new HashMap();

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public ClusterRoleBinding getRoleBinding(){
    return this.roleBinding!=null?this.roleBinding.build():null;
    }
    public T withRoleBinding( ClusterRoleBinding roleBinding){
    if (roleBinding!=null){ this.roleBinding= new ClusterRoleBindingBuilder(roleBinding); _visitables.add(this.roleBinding);} return (T) this;
    }
    public RoleBindingNested<T> withNewRoleBinding(){
    return new RoleBindingNestedImpl<T>();
    }
    public RoleBindingNested<T> withNewRoleBindingLike( ClusterRoleBinding item){
    return new RoleBindingNestedImpl<T>(item);
    }
    public RoleBindingNested<T> editRoleBinding(){
    return withNewRoleBindingLike(getRoleBinding());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedClusterRoleBindingFluentImpl that = (NamedClusterRoleBindingFluentImpl) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (roleBinding != null ? !roleBinding.equals(that.roleBinding) :that.roleBinding != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RoleBindingNestedImpl<N> extends ClusterRoleBindingFluentImpl<RoleBindingNested<N>> implements RoleBindingNested<N>{

        private final ClusterRoleBindingBuilder builder;
    
             RoleBindingNestedImpl (){
        this.builder = new ClusterRoleBindingBuilder(this);
        }
             RoleBindingNestedImpl ( ClusterRoleBinding item){
        this.builder = new ClusterRoleBindingBuilder(this, item);
        }
    
            public N endRoleBinding(){
            return and();
        }
            public N and(){
            return (N) NamedClusterRoleBindingFluentImpl.this.withRoleBinding(builder.build());
        }
    
}


}
