package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class PodFluentImpl<T extends PodFluent<T>> extends BaseFluent<T> implements PodFluent<T>{

     Pod.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<PodSpec, ?> spec;     VisitableBuilder<PodStatus, ?> status;     Map<String, Object> additionalProperties = new HashMap();

    public Pod.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Pod.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public PodSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( PodSpec spec){
    if (spec!=null){ this.spec= new PodSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNestedImpl<T>();
    }
    public SpecNested<T> withNewSpecLike( PodSpec item){
    return new SpecNestedImpl<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public PodStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public T withStatus( PodStatus status){
    if (status!=null){ this.status= new PodStatusBuilder(status); _visitables.add(this.status);} return (T) this;
    }
    public StatusNested<T> withNewStatus(){
    return new StatusNestedImpl<T>();
    }
    public StatusNested<T> withNewStatusLike( PodStatus item){
    return new StatusNestedImpl<T>(item);
    }
    public StatusNested<T> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodFluentImpl that = (PodFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) PodFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNestedImpl<N> extends PodSpecFluentImpl<SpecNested<N>> implements SpecNested<N>{

        private final PodSpecBuilder builder;
    
             SpecNestedImpl (){
        this.builder = new PodSpecBuilder(this);
        }
             SpecNestedImpl ( PodSpec item){
        this.builder = new PodSpecBuilder(this, item);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) PodFluentImpl.this.withSpec(builder.build());
        }
    
}
    public class StatusNestedImpl<N> extends PodStatusFluentImpl<StatusNested<N>> implements StatusNested<N>{

        private final PodStatusBuilder builder;
    
             StatusNestedImpl (){
        this.builder = new PodStatusBuilder(this);
        }
             StatusNestedImpl ( PodStatus item){
        this.builder = new PodStatusBuilder(this, item);
        }
    
            public N and(){
            return (N) PodFluentImpl.this.withStatus(builder.build());
        }
            public N endStatus(){
            return and();
        }
    
}


}
