package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface EndpointsFluent<T extends EndpointsFluent<T>> extends Fluent<T>{


    public Endpoints.ApiVersion getApiVersion();    public T withApiVersion( Endpoints.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToSubsets( EndpointSubset ...items);    public T removeFromSubsets( EndpointSubset ...items);    public List<EndpointSubset> getSubsets();    public T withSubsets( List<EndpointSubset> subsets);    public T withSubsets( EndpointSubset ...subsets);    public SubsetsNested<T> addNewSubset();    public SubsetsNested<T> addNewSubsetLike( EndpointSubset item);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SubsetsNested<N> extends Nested<N>, EndpointSubsetFluent<SubsetsNested<N>>{
            public N and();            public N endSubset();        
}


}
