package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ClusterFluent<T extends ClusterFluent<T>> extends Fluent<T>{


    public String getApiVersion();    public T withApiVersion( String apiVersion);    public String getCertificateAuthority();    public T withCertificateAuthority( String certificateAuthority);    public String getCertificateAuthorityData();    public T withCertificateAuthorityData( String certificateAuthorityData);    public T addToExtensions( NamedExtension ...items);    public T removeFromExtensions( NamedExtension ...items);    public List<NamedExtension> getExtensions();    public T withExtensions( List<NamedExtension> extensions);    public T withExtensions( NamedExtension ...extensions);    public ExtensionsNested<T> addNewExtension();    public ExtensionsNested<T> addNewExtensionLike( NamedExtension item);    public Boolean isInsecureSkipTlsVerify();    public T withInsecureSkipTlsVerify( Boolean insecureSkipTlsVerify);    public String getServer();    public T withServer( String server);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ExtensionsNested<N> extends Nested<N>, NamedExtensionFluent<ExtensionsNested<N>>{
            public N and();            public N endExtension();        
}


}
