package io.fabric8.openshift.api.model;

import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class RouteFluentImpl<T extends RouteFluent<T>> extends BaseFluent<T> implements RouteFluent<T>{

     Route.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<RouteSpec, ?> spec;     RouteStatus status;     Map<String, Object> additionalProperties = new HashMap();

    public Route.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Route.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public RouteSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( RouteSpec spec){
    if (spec!=null){ this.spec= new RouteSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNestedImpl<T>();
    }
    public SpecNested<T> withNewSpecLike( RouteSpec item){
    return new SpecNestedImpl<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public RouteStatus getStatus(){
    return this.status;
    }
    public T withStatus( RouteStatus status){
    this.status=status; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RouteFluentImpl that = (RouteFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) RouteFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNestedImpl<N> extends RouteSpecFluentImpl<SpecNested<N>> implements SpecNested<N>{

        private final RouteSpecBuilder builder;
    
             SpecNestedImpl (){
        this.builder = new RouteSpecBuilder(this);
        }
             SpecNestedImpl ( RouteSpec item){
        this.builder = new RouteSpecBuilder(this, item);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) RouteFluentImpl.this.withSpec(builder.build());
        }
    
}


}
