package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface ClusterRoleBindingFluent<T extends ClusterRoleBindingFluent<T>> extends Fluent<T>{


    public ClusterRoleBinding.ApiVersion getApiVersion();    public T withApiVersion( ClusterRoleBinding.ApiVersion apiVersion);    public T addToGroupNames( String ...items);    public T removeFromGroupNames( String ...items);    public List<String> getGroupNames();    public T withGroupNames( List<String> groupNames);    public T withGroupNames( String ...groupNames);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public ObjectReference getRoleRef();    public T withRoleRef( ObjectReference roleRef);    public RoleRefNested<T> withNewRoleRef();    public RoleRefNested<T> withNewRoleRefLike( ObjectReference item);    public RoleRefNested<T> editRoleRef();    public T addToSubjects( ObjectReference ...items);    public T removeFromSubjects( ObjectReference ...items);    public List<ObjectReference> getSubjects();    public T withSubjects( List<ObjectReference> subjects);    public T withSubjects( ObjectReference ...subjects);    public SubjectsNested<T> addNewSubject();    public SubjectsNested<T> addNewSubjectLike( ObjectReference item);    public T addToUserNames( String ...items);    public T removeFromUserNames( String ...items);    public List<String> getUserNames();    public T withUserNames( List<String> userNames);    public T withUserNames( String ...userNames);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface RoleRefNested<N> extends Nested<N>, ObjectReferenceFluent<RoleRefNested<N>>{
            public N endRoleRef();            public N and();        
}

    public interface SubjectsNested<N> extends Nested<N>, ObjectReferenceFluent<SubjectsNested<N>>{
            public N and();            public N endSubject();        
}


}
