package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public class BuildConfigListFluentImpl<T extends BuildConfigListFluent<T>> extends BaseFluent<T> implements BuildConfigListFluent<T>{

     BuildConfigList.ApiVersion apiVersion;     List<VisitableBuilder<BuildConfig, ?>> items = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public BuildConfigList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( BuildConfigList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public T removeFromItems( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (T)this;
    }
    public List<BuildConfig> getItems(){
    return build(items);
    }
    public T withItems( List<BuildConfig> items){
    this.items.clear();if (items != null) {for (BuildConfig item : items){this.addToItems(item);}} return (T) this;
    }
    public T withItems( BuildConfig ...items){
    this.items.clear(); if (items != null) {for (BuildConfig item :items){ this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNestedImpl<T>();
    }
    public ItemsNested<T> addNewItemLike( BuildConfig item){
    return new ItemsNestedImpl<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildConfigListFluentImpl that = (BuildConfigListFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ItemsNestedImpl<N> extends BuildConfigFluentImpl<ItemsNested<N>> implements ItemsNested<N>{

        private final BuildConfigBuilder builder;
    
             ItemsNestedImpl (){
        this.builder = new BuildConfigBuilder(this);
        }
             ItemsNestedImpl ( BuildConfig item){
        this.builder = new BuildConfigBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) BuildConfigListFluentImpl.this.addToItems(builder.build());
        }
    
}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNestedImpl ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigListFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
