package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ProbeFluent<T extends ProbeFluent<T>> extends Fluent<T>{


    public ExecAction getExec();    public T withExec( ExecAction exec);    public ExecNested<T> withNewExec();    public ExecNested<T> withNewExecLike( ExecAction item);    public ExecNested<T> editExec();    public HTTPGetAction getHttpGet();    public T withHttpGet( HTTPGetAction httpGet);    public HttpGetNested<T> withNewHttpGet();    public HttpGetNested<T> withNewHttpGetLike( HTTPGetAction item);    public HttpGetNested<T> editHttpGet();    public Long getInitialDelaySeconds();    public T withInitialDelaySeconds( Long initialDelaySeconds);    public TCPSocketAction getTcpSocket();    public T withTcpSocket( TCPSocketAction tcpSocket);    public TcpSocketNested<T> withNewTcpSocket();    public TcpSocketNested<T> withNewTcpSocketLike( TCPSocketAction item);    public TcpSocketNested<T> editTcpSocket();    public Long getTimeoutSeconds();    public T withTimeoutSeconds( Long timeoutSeconds);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ExecNested<N> extends Nested<N>, ExecActionFluent<ExecNested<N>>{
            public N and();            public N endExec();        
}

    public interface HttpGetNested<N> extends Nested<N>, HTTPGetActionFluent<HttpGetNested<N>>{
            public N endHttpGet();            public N and();        
}

    public interface TcpSocketNested<N> extends Nested<N>, TCPSocketActionFluent<TcpSocketNested<N>>{
            public N and();            public N endTcpSocket();        
}


}
