package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ContainerStatusFluent<T extends ContainerStatusFluent<T>> extends Fluent<T>{


    public String getContainerID();    public T withContainerID( String containerID);    public String getImage();    public T withImage( String image);    public String getImageID();    public T withImageID( String imageID);    public ContainerState getLastState();    public T withLastState( ContainerState lastState);    public LastStateNested<T> withNewLastState();    public LastStateNested<T> withNewLastStateLike( ContainerState item);    public LastStateNested<T> editLastState();    public String getName();    public T withName( String name);    public Boolean isReady();    public T withReady( Boolean ready);    public Integer getRestartCount();    public T withRestartCount( Integer restartCount);    public ContainerState getState();    public T withState( ContainerState state);    public StateNested<T> withNewState();    public StateNested<T> withNewStateLike( ContainerState item);    public StateNested<T> editState();    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface LastStateNested<N> extends Nested<N>, ContainerStateFluent<LastStateNested<N>>{
            public N endLastState();            public N and();        
}

    public interface StateNested<N> extends Nested<N>, ContainerStateFluent<StateNested<N>>{
            public N and();            public N endState();        
}


}
