package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class BuildTriggerPolicyFluent<T extends BuildTriggerPolicyFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<WebHookTrigger, ?> generic;     VisitableBuilder<WebHookTrigger, ?> github;     VisitableBuilder<ImageChangeTrigger, ?> imageChange;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public WebHookTrigger getGeneric(){
    return this.generic!=null?this.generic.build():null;
    }
    public T withGeneric( WebHookTrigger generic){
    if (generic!=null){ this.generic= new WebHookTriggerBuilder(generic); _visitables.add(this.generic);} return (T) this;
    }
    public GenericNested<T> withNewGeneric(){
    return new GenericNested<T>();
    }
    public GenericNested<T> withNewGenericLike( WebHookTrigger item){
    return new GenericNested<T>(item);
    }
    public GenericNested<T> editGeneric(){
    return withNewGenericLike(getGeneric());
    }
    public T withNewGeneric( String secret){
    return withGeneric(new WebHookTrigger(secret));
    }
    public WebHookTrigger getGithub(){
    return this.github!=null?this.github.build():null;
    }
    public T withGithub( WebHookTrigger github){
    if (github!=null){ this.github= new WebHookTriggerBuilder(github); _visitables.add(this.github);} return (T) this;
    }
    public GithubNested<T> withNewGithub(){
    return new GithubNested<T>();
    }
    public GithubNested<T> withNewGithubLike( WebHookTrigger item){
    return new GithubNested<T>(item);
    }
    public GithubNested<T> editGithub(){
    return withNewGithubLike(getGithub());
    }
    public T withNewGithub( String secret){
    return withGithub(new WebHookTrigger(secret));
    }
    public ImageChangeTrigger getImageChange(){
    return this.imageChange!=null?this.imageChange.build():null;
    }
    public T withImageChange( ImageChangeTrigger imageChange){
    if (imageChange!=null){ this.imageChange= new ImageChangeTriggerBuilder(imageChange); _visitables.add(this.imageChange);} return (T) this;
    }
    public ImageChangeNested<T> withNewImageChange(){
    return new ImageChangeNested<T>();
    }
    public ImageChangeNested<T> withNewImageChangeLike( ImageChangeTrigger item){
    return new ImageChangeNested<T>(item);
    }
    public ImageChangeNested<T> editImageChange(){
    return withNewImageChangeLike(getImageChange());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildTriggerPolicyFluent that = (BuildTriggerPolicyFluent) o;
if (generic != null ? !generic.equals(that.generic) :that.generic != null) return false;
if (github != null ? !github.equals(that.github) :that.github != null) return false;
if (imageChange != null ? !imageChange.equals(that.imageChange) :that.imageChange != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class GenericNested<N> extends WebHookTriggerFluent<GenericNested<N>> implements Nested<N>{

        private final WebHookTriggerBuilder builder;
    
             GenericNested (){
        this.builder = new WebHookTriggerBuilder(this);
        }
             GenericNested ( WebHookTrigger item){
        this.builder = new WebHookTriggerBuilder(this, item);
        }
    
            public N endGeneric(){
            return and();
        }
            public N and(){
            return (N) BuildTriggerPolicyFluent.this.withGeneric(builder.build());
        }
    
}
    public class GithubNested<N> extends WebHookTriggerFluent<GithubNested<N>> implements Nested<N>{

        private final WebHookTriggerBuilder builder;
    
             GithubNested (){
        this.builder = new WebHookTriggerBuilder(this);
        }
             GithubNested ( WebHookTrigger item){
        this.builder = new WebHookTriggerBuilder(this, item);
        }
    
            public N endGithub(){
            return and();
        }
            public N and(){
            return (N) BuildTriggerPolicyFluent.this.withGithub(builder.build());
        }
    
}
    public class ImageChangeNested<N> extends ImageChangeTriggerFluent<ImageChangeNested<N>> implements Nested<N>{

        private final ImageChangeTriggerBuilder builder;
    
             ImageChangeNested (){
        this.builder = new ImageChangeTriggerBuilder(this);
        }
             ImageChangeNested ( ImageChangeTrigger item){
        this.builder = new ImageChangeTriggerBuilder(this, item);
        }
    
            public N endImageChange(){
            return and();
        }
            public N and(){
            return (N) BuildTriggerPolicyFluent.this.withImageChange(builder.build());
        }
    
}


}
