package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ServicePortBuilder extends ServicePortFluent<ServicePortBuilder> implements VisitableBuilder<ServicePort,ServicePortBuilder>{

     ServicePortFluent<?> fluent;
public ServicePortBuilder(){
    this(new ServicePort());
}
public ServicePortBuilder( ServicePortFluent<?> fluent ){
    this(fluent, new ServicePort());
}
public ServicePortBuilder( ServicePortFluent<?> fluent , ServicePort instance ){
    this.fluent = fluent; fluent.withName(instance.getName()); fluent.withNodePort(instance.getNodePort()); fluent.withPort(instance.getPort()); fluent.withProtocol(instance.getProtocol()); fluent.withTargetPort(instance.getTargetPort()); 
}
public ServicePortBuilder( ServicePort instance ){
    this.fluent = this; this.withName(instance.getName()); this.withNodePort(instance.getNodePort()); this.withPort(instance.getPort()); this.withProtocol(instance.getProtocol()); this.withTargetPort(instance.getTargetPort()); 
}

public EditableServicePort build(){
    EditableServicePort buildable = new EditableServicePort(fluent.getName(),fluent.getNodePort(),fluent.getPort(),fluent.getProtocol(),fluent.getTargetPort());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ServicePortBuilder that = (ServicePortBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    