package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ContainerFluent<T extends ContainerFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     List<String> args = new ArrayList();     List<String> command = new ArrayList();     List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();     String image;     String imagePullPolicy;     VisitableBuilder<Lifecycle, ?> lifecycle;     VisitableBuilder<Probe, ?> livenessProbe;     String name;     List<VisitableBuilder<ContainerPort, ?>> ports = new ArrayList();     VisitableBuilder<Probe, ?> readinessProbe;     VisitableBuilder<ResourceRequirements, ?> resources;     VisitableBuilder<SecurityContext, ?> securityContext;     Boolean stdin;     String terminationMessagePath;     Boolean tty;     List<VisitableBuilder<VolumeMount, ?>> volumeMounts = new ArrayList();     String workingDir;     Map<String, Object> additionalProperties = new HashMap();

    public T addToArgs( String ...items){
    for (String item : items) {this.args.add(item);} return (T)this;
    }
    public T removeFromArgs( String ...items){
    for (String item : items) {this.args.remove(item);} return (T)this;
    }
    public List<String> getArgs(){
    return this.args;
    }
    public T withArgs( List<String> args){
    this.args.clear();if (args != null) {for (String item : args){this.addToArgs(item);}} return (T) this;
    }
    public T withArgs( String ...args){
    this.args.clear(); if (args != null) {for (String item :args){ this.addToArgs(item);}} return (T) this;
    }
    public T addToCommand( String ...items){
    for (String item : items) {this.command.add(item);} return (T)this;
    }
    public T removeFromCommand( String ...items){
    for (String item : items) {this.command.remove(item);} return (T)this;
    }
    public List<String> getCommand(){
    return this.command;
    }
    public T withCommand( List<String> command){
    this.command.clear();if (command != null) {for (String item : command){this.addToCommand(item);}} return (T) this;
    }
    public T withCommand( String ...command){
    this.command.clear(); if (command != null) {for (String item :command){ this.addToCommand(item);}} return (T) this;
    }
    public T addToEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (T)this;
    }
    public T removeFromEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (T)this;
    }
    public List<EnvVar> getEnv(){
    return build(env);
    }
    public T withEnv( List<EnvVar> env){
    this.env.clear();if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (T) this;
    }
    public T withEnv( EnvVar ...env){
    this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (T) this;
    }
    public EnvNested<T> addNewEnv(){
    return new EnvNested<T>();
    }
    public EnvNested<T> addNewEnvLike( EnvVar item){
    return new EnvNested<T>(item);
    }
    public String getImage(){
    return this.image;
    }
    public T withImage( String image){
    this.image=image; return (T) this;
    }
    public String getImagePullPolicy(){
    return this.imagePullPolicy;
    }
    public T withImagePullPolicy( String imagePullPolicy){
    this.imagePullPolicy=imagePullPolicy; return (T) this;
    }
    public Lifecycle getLifecycle(){
    return this.lifecycle!=null?this.lifecycle.build():null;
    }
    public T withLifecycle( Lifecycle lifecycle){
    if (lifecycle!=null){ this.lifecycle= new LifecycleBuilder(lifecycle); _visitables.add(this.lifecycle);} return (T) this;
    }
    public LifecycleNested<T> withNewLifecycle(){
    return new LifecycleNested<T>();
    }
    public LifecycleNested<T> withNewLifecycleLike( Lifecycle item){
    return new LifecycleNested<T>(item);
    }
    public LifecycleNested<T> editLifecycle(){
    return withNewLifecycleLike(getLifecycle());
    }
    public Probe getLivenessProbe(){
    return this.livenessProbe!=null?this.livenessProbe.build():null;
    }
    public T withLivenessProbe( Probe livenessProbe){
    if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.add(this.livenessProbe);} return (T) this;
    }
    public LivenessProbeNested<T> withNewLivenessProbe(){
    return new LivenessProbeNested<T>();
    }
    public LivenessProbeNested<T> withNewLivenessProbeLike( Probe item){
    return new LivenessProbeNested<T>(item);
    }
    public LivenessProbeNested<T> editLivenessProbe(){
    return withNewLivenessProbeLike(getLivenessProbe());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public T addToPorts( ContainerPort ...items){
    for (ContainerPort item : items) {ContainerPortBuilder builder = new ContainerPortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (T)this;
    }
    public T removeFromPorts( ContainerPort ...items){
    for (ContainerPort item : items) {ContainerPortBuilder builder = new ContainerPortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (T)this;
    }
    public List<ContainerPort> getPorts(){
    return build(ports);
    }
    public T withPorts( List<ContainerPort> ports){
    this.ports.clear();if (ports != null) {for (ContainerPort item : ports){this.addToPorts(item);}} return (T) this;
    }
    public T withPorts( ContainerPort ...ports){
    this.ports.clear(); if (ports != null) {for (ContainerPort item :ports){ this.addToPorts(item);}} return (T) this;
    }
    public PortsNested<T> addNewPort(){
    return new PortsNested<T>();
    }
    public PortsNested<T> addNewPortLike( ContainerPort item){
    return new PortsNested<T>(item);
    }
    public T addNewPort( Integer containerPort,  String hostIP,  Integer hostPort,  String name,  String protocol){
    return addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }
    public Probe getReadinessProbe(){
    return this.readinessProbe!=null?this.readinessProbe.build():null;
    }
    public T withReadinessProbe( Probe readinessProbe){
    if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.add(this.readinessProbe);} return (T) this;
    }
    public ReadinessProbeNested<T> withNewReadinessProbe(){
    return new ReadinessProbeNested<T>();
    }
    public ReadinessProbeNested<T> withNewReadinessProbeLike( Probe item){
    return new ReadinessProbeNested<T>(item);
    }
    public ReadinessProbeNested<T> editReadinessProbe(){
    return withNewReadinessProbeLike(getReadinessProbe());
    }
    public ResourceRequirements getResources(){
    return this.resources!=null?this.resources.build():null;
    }
    public T withResources( ResourceRequirements resources){
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (T) this;
    }
    public ResourcesNested<T> withNewResources(){
    return new ResourcesNested<T>();
    }
    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item){
    return new ResourcesNested<T>(item);
    }
    public ResourcesNested<T> editResources(){
    return withNewResourcesLike(getResources());
    }
    public SecurityContext getSecurityContext(){
    return this.securityContext!=null?this.securityContext.build():null;
    }
    public T withSecurityContext( SecurityContext securityContext){
    if (securityContext!=null){ this.securityContext= new SecurityContextBuilder(securityContext); _visitables.add(this.securityContext);} return (T) this;
    }
    public SecurityContextNested<T> withNewSecurityContext(){
    return new SecurityContextNested<T>();
    }
    public SecurityContextNested<T> withNewSecurityContextLike( SecurityContext item){
    return new SecurityContextNested<T>(item);
    }
    public SecurityContextNested<T> editSecurityContext(){
    return withNewSecurityContextLike(getSecurityContext());
    }
    public Boolean isStdin(){
    return this.stdin;
    }
    public T withStdin( Boolean stdin){
    this.stdin=stdin; return (T) this;
    }
    public String getTerminationMessagePath(){
    return this.terminationMessagePath;
    }
    public T withTerminationMessagePath( String terminationMessagePath){
    this.terminationMessagePath=terminationMessagePath; return (T) this;
    }
    public Boolean isTty(){
    return this.tty;
    }
    public T withTty( Boolean tty){
    this.tty=tty; return (T) this;
    }
    public T addToVolumeMounts( VolumeMount ...items){
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.add(builder);this.volumeMounts.add(builder);} return (T)this;
    }
    public T removeFromVolumeMounts( VolumeMount ...items){
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.remove(builder);this.volumeMounts.remove(builder);} return (T)this;
    }
    public List<VolumeMount> getVolumeMounts(){
    return build(volumeMounts);
    }
    public T withVolumeMounts( List<VolumeMount> volumeMounts){
    this.volumeMounts.clear();if (volumeMounts != null) {for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} return (T) this;
    }
    public T withVolumeMounts( VolumeMount ...volumeMounts){
    this.volumeMounts.clear(); if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (T) this;
    }
    public VolumeMountsNested<T> addNewVolumeMount(){
    return new VolumeMountsNested<T>();
    }
    public VolumeMountsNested<T> addNewVolumeMountLike( VolumeMount item){
    return new VolumeMountsNested<T>(item);
    }
    public T addNewVolumeMount( String mountPath,  String name,  Boolean readOnly){
    return addToVolumeMounts(new VolumeMount(mountPath, name, readOnly));
    }
    public String getWorkingDir(){
    return this.workingDir;
    }
    public T withWorkingDir( String workingDir){
    this.workingDir=workingDir; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerFluent that = (ContainerFluent) o;
if (args != null ? !args.equals(that.args) :that.args != null) return false;
if (command != null ? !command.equals(that.command) :that.command != null) return false;
if (env != null ? !env.equals(that.env) :that.env != null) return false;
if (image != null ? !image.equals(that.image) :that.image != null) return false;
if (imagePullPolicy != null ? !imagePullPolicy.equals(that.imagePullPolicy) :that.imagePullPolicy != null) return false;
if (lifecycle != null ? !lifecycle.equals(that.lifecycle) :that.lifecycle != null) return false;
if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
if (stdin != null ? !stdin.equals(that.stdin) :that.stdin != null) return false;
if (terminationMessagePath != null ? !terminationMessagePath.equals(that.terminationMessagePath) :that.terminationMessagePath != null) return false;
if (tty != null ? !tty.equals(that.tty) :that.tty != null) return false;
if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
if (workingDir != null ? !workingDir.equals(that.workingDir) :that.workingDir != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class EnvNested<N> extends EnvVarFluent<EnvNested<N>> implements Nested<N>{

        private final EnvVarBuilder builder;
    
             EnvNested (){
        this.builder = new EnvVarBuilder(this);
        }
             EnvNested ( EnvVar item){
        this.builder = new EnvVarBuilder(this, item);
        }
    
            public N endEnv(){
            return and();
        }
            public N and(){
            return (N) ContainerFluent.this.addToEnv(builder.build());
        }
    
}
    public class LifecycleNested<N> extends LifecycleFluent<LifecycleNested<N>> implements Nested<N>{

        private final LifecycleBuilder builder;
    
             LifecycleNested ( Lifecycle item){
        this.builder = new LifecycleBuilder(this, item);
        }
             LifecycleNested (){
        this.builder = new LifecycleBuilder(this);
        }
    
            public N endLifecycle(){
            return and();
        }
            public N and(){
            return (N) ContainerFluent.this.withLifecycle(builder.build());
        }
    
}
    public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{

        private final ProbeBuilder builder;
    
             LivenessProbeNested ( Probe item){
        this.builder = new ProbeBuilder(this, item);
        }
             LivenessProbeNested (){
        this.builder = new ProbeBuilder(this);
        }
    
            public N endLivenessProbe(){
            return and();
        }
            public N and(){
            return (N) ContainerFluent.this.withLivenessProbe(builder.build());
        }
    
}
    public class PortsNested<N> extends ContainerPortFluent<PortsNested<N>> implements Nested<N>{

        private final ContainerPortBuilder builder;
    
             PortsNested (){
        this.builder = new ContainerPortBuilder(this);
        }
             PortsNested ( ContainerPort item){
        this.builder = new ContainerPortBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) ContainerFluent.this.addToPorts(builder.build());
        }
    
}
    public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{

        private final ProbeBuilder builder;
    
             ReadinessProbeNested (){
        this.builder = new ProbeBuilder(this);
        }
             ReadinessProbeNested ( Probe item){
        this.builder = new ProbeBuilder(this, item);
        }
    
            public N endReadinessProbe(){
            return and();
        }
            public N and(){
            return (N) ContainerFluent.this.withReadinessProbe(builder.build());
        }
    
}
    public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{

        private final ResourceRequirementsBuilder builder;
    
             ResourcesNested (){
        this.builder = new ResourceRequirementsBuilder(this);
        }
             ResourcesNested ( ResourceRequirements item){
        this.builder = new ResourceRequirementsBuilder(this, item);
        }
    
            public N endResources(){
            return and();
        }
            public N and(){
            return (N) ContainerFluent.this.withResources(builder.build());
        }
    
}
    public class SecurityContextNested<N> extends SecurityContextFluent<SecurityContextNested<N>> implements Nested<N>{

        private final SecurityContextBuilder builder;
    
             SecurityContextNested (){
        this.builder = new SecurityContextBuilder(this);
        }
             SecurityContextNested ( SecurityContext item){
        this.builder = new SecurityContextBuilder(this, item);
        }
    
            public N endSecurityContext(){
            return and();
        }
            public N and(){
            return (N) ContainerFluent.this.withSecurityContext(builder.build());
        }
    
}
    public class VolumeMountsNested<N> extends VolumeMountFluent<VolumeMountsNested<N>> implements Nested<N>{

        private final VolumeMountBuilder builder;
    
             VolumeMountsNested (){
        this.builder = new VolumeMountBuilder(this);
        }
             VolumeMountsNested ( VolumeMount item){
        this.builder = new VolumeMountBuilder(this, item);
        }
    
            public N endVolumeMount(){
            return and();
        }
            public N and(){
            return (N) ContainerFluent.this.addToVolumeMounts(builder.build());
        }
    
}


}
