package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ConfigFluent<T extends ConfigFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String apiVersion;     List<VisitableBuilder<NamedCluster, ?>> clusters = new ArrayList();     List<VisitableBuilder<NamedContext, ?>> contexts = new ArrayList();     String currentContext;     List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();     String kind;     VisitableBuilder<Preferences, ?> preferences;     List<VisitableBuilder<NamedAuthInfo, ?>> users = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToClusters( NamedCluster ...items){
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.add(builder);this.clusters.add(builder);} return (T)this;
    }
    public T removeFromClusters( NamedCluster ...items){
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.remove(builder);this.clusters.remove(builder);} return (T)this;
    }
    public List<NamedCluster> getClusters(){
    return build(clusters);
    }
    public T withClusters( List<NamedCluster> clusters){
    this.clusters.clear();if (clusters != null) {for (NamedCluster item : clusters){this.addToClusters(item);}} return (T) this;
    }
    public T withClusters( NamedCluster ...clusters){
    this.clusters.clear(); if (clusters != null) {for (NamedCluster item :clusters){ this.addToClusters(item);}} return (T) this;
    }
    public ClustersNested<T> addNewCluster(){
    return new ClustersNested<T>();
    }
    public ClustersNested<T> addNewClusterLike( NamedCluster item){
    return new ClustersNested<T>(item);
    }
    public T addToContexts( NamedContext ...items){
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.add(builder);this.contexts.add(builder);} return (T)this;
    }
    public T removeFromContexts( NamedContext ...items){
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.remove(builder);this.contexts.remove(builder);} return (T)this;
    }
    public List<NamedContext> getContexts(){
    return build(contexts);
    }
    public T withContexts( List<NamedContext> contexts){
    this.contexts.clear();if (contexts != null) {for (NamedContext item : contexts){this.addToContexts(item);}} return (T) this;
    }
    public T withContexts( NamedContext ...contexts){
    this.contexts.clear(); if (contexts != null) {for (NamedContext item :contexts){ this.addToContexts(item);}} return (T) this;
    }
    public ContextsNested<T> addNewContext(){
    return new ContextsNested<T>();
    }
    public ContextsNested<T> addNewContextLike( NamedContext item){
    return new ContextsNested<T>(item);
    }
    public String getCurrentContext(){
    return this.currentContext;
    }
    public T withCurrentContext( String currentContext){
    this.currentContext=currentContext; return (T) this;
    }
    public T addToExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (T)this;
    }
    public T removeFromExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (T)this;
    }
    public List<NamedExtension> getExtensions(){
    return build(extensions);
    }
    public T withExtensions( List<NamedExtension> extensions){
    this.extensions.clear();if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (T) this;
    }
    public T withExtensions( NamedExtension ...extensions){
    this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (T) this;
    }
    public ExtensionsNested<T> addNewExtension(){
    return new ExtensionsNested<T>();
    }
    public ExtensionsNested<T> addNewExtensionLike( NamedExtension item){
    return new ExtensionsNested<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public Preferences getPreferences(){
    return this.preferences!=null?this.preferences.build():null;
    }
    public T withPreferences( Preferences preferences){
    if (preferences!=null){ this.preferences= new PreferencesBuilder(preferences); _visitables.add(this.preferences);} return (T) this;
    }
    public PreferencesNested<T> withNewPreferences(){
    return new PreferencesNested<T>();
    }
    public PreferencesNested<T> withNewPreferencesLike( Preferences item){
    return new PreferencesNested<T>(item);
    }
    public PreferencesNested<T> editPreferences(){
    return withNewPreferencesLike(getPreferences());
    }
    public T addToUsers( NamedAuthInfo ...items){
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.add(builder);this.users.add(builder);} return (T)this;
    }
    public T removeFromUsers( NamedAuthInfo ...items){
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.remove(builder);this.users.remove(builder);} return (T)this;
    }
    public List<NamedAuthInfo> getUsers(){
    return build(users);
    }
    public T withUsers( List<NamedAuthInfo> users){
    this.users.clear();if (users != null) {for (NamedAuthInfo item : users){this.addToUsers(item);}} return (T) this;
    }
    public T withUsers( NamedAuthInfo ...users){
    this.users.clear(); if (users != null) {for (NamedAuthInfo item :users){ this.addToUsers(item);}} return (T) this;
    }
    public UsersNested<T> addNewUser(){
    return new UsersNested<T>();
    }
    public UsersNested<T> addNewUserLike( NamedAuthInfo item){
    return new UsersNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ConfigFluent that = (ConfigFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (clusters != null ? !clusters.equals(that.clusters) :that.clusters != null) return false;
if (contexts != null ? !contexts.equals(that.contexts) :that.contexts != null) return false;
if (currentContext != null ? !currentContext.equals(that.currentContext) :that.currentContext != null) return false;
if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (preferences != null ? !preferences.equals(that.preferences) :that.preferences != null) return false;
if (users != null ? !users.equals(that.users) :that.users != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ClustersNested<N> extends NamedClusterFluent<ClustersNested<N>> implements Nested<N>{

        private final NamedClusterBuilder builder;
    
             ClustersNested (){
        this.builder = new NamedClusterBuilder(this);
        }
             ClustersNested ( NamedCluster item){
        this.builder = new NamedClusterBuilder(this, item);
        }
    
            public N endCluster(){
            return and();
        }
            public N and(){
            return (N) ConfigFluent.this.addToClusters(builder.build());
        }
    
}
    public class ContextsNested<N> extends NamedContextFluent<ContextsNested<N>> implements Nested<N>{

        private final NamedContextBuilder builder;
    
             ContextsNested (){
        this.builder = new NamedContextBuilder(this);
        }
             ContextsNested ( NamedContext item){
        this.builder = new NamedContextBuilder(this, item);
        }
    
            public N endContext(){
            return and();
        }
            public N and(){
            return (N) ConfigFluent.this.addToContexts(builder.build());
        }
    
}
    public class ExtensionsNested<N> extends NamedExtensionFluent<ExtensionsNested<N>> implements Nested<N>{

        private final NamedExtensionBuilder builder;
    
             ExtensionsNested (){
        this.builder = new NamedExtensionBuilder(this);
        }
             ExtensionsNested ( NamedExtension item){
        this.builder = new NamedExtensionBuilder(this, item);
        }
    
            public N endExtension(){
            return and();
        }
            public N and(){
            return (N) ConfigFluent.this.addToExtensions(builder.build());
        }
    
}
    public class PreferencesNested<N> extends PreferencesFluent<PreferencesNested<N>> implements Nested<N>{

        private final PreferencesBuilder builder;
    
             PreferencesNested (){
        this.builder = new PreferencesBuilder(this);
        }
             PreferencesNested ( Preferences item){
        this.builder = new PreferencesBuilder(this, item);
        }
    
            public N endPreferences(){
            return and();
        }
            public N and(){
            return (N) ConfigFluent.this.withPreferences(builder.build());
        }
    
}
    public class UsersNested<N> extends NamedAuthInfoFluent<UsersNested<N>> implements Nested<N>{

        private final NamedAuthInfoBuilder builder;
    
             UsersNested (){
        this.builder = new NamedAuthInfoBuilder(this);
        }
             UsersNested ( NamedAuthInfo item){
        this.builder = new NamedAuthInfoBuilder(this, item);
        }
    
            public N endUser(){
            return and();
        }
            public N and(){
            return (N) ConfigFluent.this.addToUsers(builder.build());
        }
    
}


}
