package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ContainerBuilder extends ContainerFluent<ContainerBuilder> implements VisitableBuilder<Container,ContainerBuilder>{

     ContainerFluent<?> fluent;
public ContainerBuilder(){
    this(new Container());
}
public ContainerBuilder( ContainerFluent<?> fluent ){
    this(fluent, new Container());
}
public ContainerBuilder( ContainerFluent<?> fluent , Container instance ){
    this.fluent = fluent; fluent.withArgs(instance.getArgs()); fluent.withCommand(instance.getCommand()); fluent.withEnv(instance.getEnv()); fluent.withImage(instance.getImage()); fluent.withImagePullPolicy(instance.getImagePullPolicy()); fluent.withLifecycle(instance.getLifecycle()); fluent.withLivenessProbe(instance.getLivenessProbe()); fluent.withName(instance.getName()); fluent.withPorts(instance.getPorts()); fluent.withReadinessProbe(instance.getReadinessProbe()); fluent.withResources(instance.getResources()); fluent.withSecurityContext(instance.getSecurityContext()); fluent.withStdin(instance.getStdin()); fluent.withTerminationMessagePath(instance.getTerminationMessagePath()); fluent.withTty(instance.getTty()); fluent.withVolumeMounts(instance.getVolumeMounts()); fluent.withWorkingDir(instance.getWorkingDir()); 
}
public ContainerBuilder( Container instance ){
    this.fluent = this; this.withArgs(instance.getArgs()); this.withCommand(instance.getCommand()); this.withEnv(instance.getEnv()); this.withImage(instance.getImage()); this.withImagePullPolicy(instance.getImagePullPolicy()); this.withLifecycle(instance.getLifecycle()); this.withLivenessProbe(instance.getLivenessProbe()); this.withName(instance.getName()); this.withPorts(instance.getPorts()); this.withReadinessProbe(instance.getReadinessProbe()); this.withResources(instance.getResources()); this.withSecurityContext(instance.getSecurityContext()); this.withStdin(instance.getStdin()); this.withTerminationMessagePath(instance.getTerminationMessagePath()); this.withTty(instance.getTty()); this.withVolumeMounts(instance.getVolumeMounts()); this.withWorkingDir(instance.getWorkingDir()); 
}

public EditableContainer build(){
    EditableContainer buildable = new EditableContainer(fluent.getArgs(),fluent.getCommand(),fluent.getEnv(),fluent.getImage(),fluent.getImagePullPolicy(),fluent.getLifecycle(),fluent.getLivenessProbe(),fluent.getName(),fluent.getPorts(),fluent.getReadinessProbe(),fluent.getResources(),fluent.getSecurityContext(),fluent.isStdin(),fluent.getTerminationMessagePath(),fluent.isTty(),fluent.getVolumeMounts(),fluent.getWorkingDir());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerBuilder that = (ContainerBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    