package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

public class BuildOutputFluent<T extends BuildOutputFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<LocalObjectReference, ?> pushSecret;     VisitableBuilder<ObjectReference, ?> to;     Map<String, Object> additionalProperties = new HashMap();

    public LocalObjectReference getPushSecret(){
    return this.pushSecret!=null?this.pushSecret.build():null;
    }
    public T withPushSecret( LocalObjectReference pushSecret){
    if (pushSecret!=null){ this.pushSecret= new LocalObjectReferenceBuilder(pushSecret); _visitables.add(this.pushSecret);} return (T) this;
    }
    public PushSecretNested<T> withNewPushSecret(){
    return new PushSecretNested<T>();
    }
    public PushSecretNested<T> withNewPushSecretLike( LocalObjectReference item){
    return new PushSecretNested<T>(item);
    }
    public PushSecretNested<T> editPushSecret(){
    return withNewPushSecretLike(getPushSecret());
    }
    public T withNewPushSecret( String name){
    return withPushSecret(new LocalObjectReference(name));
    }
    public ObjectReference getTo(){
    return this.to!=null?this.to.build():null;
    }
    public T withTo( ObjectReference to){
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.add(this.to);} return (T) this;
    }
    public ToNested<T> withNewTo(){
    return new ToNested<T>();
    }
    public ToNested<T> withNewToLike( ObjectReference item){
    return new ToNested<T>(item);
    }
    public ToNested<T> editTo(){
    return withNewToLike(getTo());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildOutputFluent that = (BuildOutputFluent) o;
if (pushSecret != null ? !pushSecret.equals(that.pushSecret) :that.pushSecret != null) return false;
if (to != null ? !to.equals(that.to) :that.to != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class PushSecretNested<N> extends LocalObjectReferenceFluent<PushSecretNested<N>> implements Nested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             PushSecretNested (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             PushSecretNested ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N endPushSecret(){
            return and();
        }
            public N and(){
            return (N) BuildOutputFluent.this.withPushSecret(builder.build());
        }
    
}
    public class ToNested<N> extends ObjectReferenceFluent<ToNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             ToNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ToNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildOutputFluent.this.withTo(builder.build());
        }
            public N endTo(){
            return and();
        }
    
}


}
