package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamedClusterFluent<T extends NamedClusterFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<Cluster, ?> cluster;     String name;     Map<String, Object> additionalProperties = new HashMap();

    public Cluster getCluster(){
    return this.cluster!=null?this.cluster.build():null;
    }
    public T withCluster( Cluster cluster){
    if (cluster!=null){ this.cluster= new ClusterBuilder(cluster); _visitables.add(this.cluster);} return (T) this;
    }
    public ClusterNested<T> withNewCluster(){
    return new ClusterNested<T>();
    }
    public ClusterNested<T> withNewClusterLike( Cluster item){
    return new ClusterNested<T>(item);
    }
    public ClusterNested<T> editCluster(){
    return withNewClusterLike(getCluster());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedClusterFluent that = (NamedClusterFluent) o;
if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ClusterNested<N> extends ClusterFluent<ClusterNested<N>> implements Nested<N>{

        private final ClusterBuilder builder;
    
             ClusterNested (){
        this.builder = new ClusterBuilder(this);
        }
             ClusterNested ( Cluster item){
        this.builder = new ClusterBuilder(this, item);
        }
    
            public N endCluster(){
            return and();
        }
            public N and(){
            return (N) NamedClusterFluent.this.withCluster(builder.build());
        }
    
}


}
