package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class MetadataVolumeSourceFluent<T extends MetadataVolumeSourceFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     List<VisitableBuilder<MetadataFile, ?>> items = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public T addToItems( MetadataFile ...items){
    for (MetadataFile item : items) {MetadataFileBuilder builder = new MetadataFileBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public T removeFromItems( MetadataFile ...items){
    for (MetadataFile item : items) {MetadataFileBuilder builder = new MetadataFileBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (T)this;
    }
    public List<MetadataFile> getItems(){
    return build(items);
    }
    public T withItems( List<MetadataFile> items){
    this.items.clear();if (items != null) {for (MetadataFile item : items){this.addToItems(item);}} return (T) this;
    }
    public T withItems( MetadataFile ...items){
    this.items.clear(); if (items != null) {for (MetadataFile item :items){ this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNested<T>();
    }
    public ItemsNested<T> addNewItemLike( MetadataFile item){
    return new ItemsNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
MetadataVolumeSourceFluent that = (MetadataVolumeSourceFluent) o;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ItemsNested<N> extends MetadataFileFluent<ItemsNested<N>> implements Nested<N>{

        private final MetadataFileBuilder builder;
    
             ItemsNested (){
        this.builder = new MetadataFileBuilder(this);
        }
             ItemsNested ( MetadataFile item){
        this.builder = new MetadataFileBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) MetadataVolumeSourceFluent.this.addToItems(builder.build());
        }
    
}


}
