package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class PodSpecBuilder extends PodSpecFluent<PodSpecBuilder> implements VisitableBuilder<PodSpec,PodSpecBuilder>{

     PodSpecFluent<?> fluent;
public PodSpecBuilder(){
    this(new PodSpec());
}
public PodSpecBuilder( PodSpecFluent<?> fluent ){
    this(fluent, new PodSpec());
}
public PodSpecBuilder( PodSpecFluent<?> fluent , PodSpec instance ){
    this.fluent = fluent; fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); fluent.withContainers(instance.getContainers()); fluent.withDnsPolicy(instance.getDnsPolicy()); fluent.withHost(instance.getHost()); fluent.withHostNetwork(instance.getHostNetwork()); fluent.withImagePullSecrets(instance.getImagePullSecrets()); fluent.withNodeName(instance.getNodeName()); fluent.withNodeSelector(instance.getNodeSelector()); fluent.withRestartPolicy(instance.getRestartPolicy()); fluent.withServiceAccount(instance.getServiceAccount()); fluent.withServiceAccountName(instance.getServiceAccountName()); fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); fluent.withVolumes(instance.getVolumes()); 
}
public PodSpecBuilder( PodSpec instance ){
    this.fluent = this; this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); this.withContainers(instance.getContainers()); this.withDnsPolicy(instance.getDnsPolicy()); this.withHost(instance.getHost()); this.withHostNetwork(instance.getHostNetwork()); this.withImagePullSecrets(instance.getImagePullSecrets()); this.withNodeName(instance.getNodeName()); this.withNodeSelector(instance.getNodeSelector()); this.withRestartPolicy(instance.getRestartPolicy()); this.withServiceAccount(instance.getServiceAccount()); this.withServiceAccountName(instance.getServiceAccountName()); this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); this.withVolumes(instance.getVolumes()); 
}

public EditablePodSpec build(){
    EditablePodSpec buildable = new EditablePodSpec(fluent.getActiveDeadlineSeconds(),fluent.getContainers(),fluent.getDnsPolicy(),fluent.getHost(),fluent.isHostNetwork(),fluent.getImagePullSecrets(),fluent.getNodeName(),fluent.getNodeSelector(),fluent.getRestartPolicy(),fluent.getServiceAccount(),fluent.getServiceAccountName(),fluent.getTerminationGracePeriodSeconds(),fluent.getVolumes());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PodSpecBuilder that = (PodSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    