package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ServiceAccountFluent<T extends ServiceAccountFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     ServiceAccount.ApiVersion apiVersion;     List<VisitableBuilder<LocalObjectReference, ?>> imagePullSecrets = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<ObjectReference, ?>> secrets = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public ServiceAccount.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ServiceAccount.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToImagePullSecrets( LocalObjectReference ...items){
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.add(builder);this.imagePullSecrets.add(builder);} return (T)this;
    }
    public T removeFromImagePullSecrets( LocalObjectReference ...items){
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.remove(builder);this.imagePullSecrets.remove(builder);} return (T)this;
    }
    public List<LocalObjectReference> getImagePullSecrets(){
    return build(imagePullSecrets);
    }
    public T withImagePullSecrets( List<LocalObjectReference> imagePullSecrets){
    this.imagePullSecrets.clear();if (imagePullSecrets != null) {for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} return (T) this;
    }
    public T withImagePullSecrets( LocalObjectReference ...imagePullSecrets){
    this.imagePullSecrets.clear(); if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (T) this;
    }
    public ImagePullSecretsNested<T> addNewImagePullSecret(){
    return new ImagePullSecretsNested<T>();
    }
    public ImagePullSecretsNested<T> addNewImagePullSecretLike( LocalObjectReference item){
    return new ImagePullSecretsNested<T>(item);
    }
    public T addNewImagePullSecret( String name){
    return addToImagePullSecrets(new LocalObjectReference(name));
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToSecrets( ObjectReference ...items){
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.add(builder);this.secrets.add(builder);} return (T)this;
    }
    public T removeFromSecrets( ObjectReference ...items){
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.remove(builder);this.secrets.remove(builder);} return (T)this;
    }
    public List<ObjectReference> getSecrets(){
    return build(secrets);
    }
    public T withSecrets( List<ObjectReference> secrets){
    this.secrets.clear();if (secrets != null) {for (ObjectReference item : secrets){this.addToSecrets(item);}} return (T) this;
    }
    public T withSecrets( ObjectReference ...secrets){
    this.secrets.clear(); if (secrets != null) {for (ObjectReference item :secrets){ this.addToSecrets(item);}} return (T) this;
    }
    public SecretsNested<T> addNewSecret(){
    return new SecretsNested<T>();
    }
    public SecretsNested<T> addNewSecretLike( ObjectReference item){
    return new SecretsNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ServiceAccountFluent that = (ServiceAccountFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ImagePullSecretsNested<N> extends LocalObjectReferenceFluent<ImagePullSecretsNested<N>> implements Nested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             ImagePullSecretsNested (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             ImagePullSecretsNested ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) ServiceAccountFluent.this.addToImagePullSecrets(builder.build());
        }
            public N endImagePullSecret(){
            return and();
        }
    
}
    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) ServiceAccountFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SecretsNested<N> extends ObjectReferenceFluent<SecretsNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             SecretsNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
             SecretsNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
    
            public N and(){
            return (N) ServiceAccountFluent.this.addToSecrets(builder.build());
        }
            public N endSecret(){
            return and();
        }
    
}


}
